package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait TrainingRepositoryAccessMode {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.TrainingRepositoryAccessMode
}
object TrainingRepositoryAccessMode {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.TrainingRepositoryAccessMode
  ): zio.aws.sagemaker.model.TrainingRepositoryAccessMode = value match {
    case software.amazon.awssdk.services.sagemaker.model.TrainingRepositoryAccessMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.TrainingRepositoryAccessMode.PLATFORM =>
      val r = Platform
      r
    case software.amazon.awssdk.services.sagemaker.model.TrainingRepositoryAccessMode.VPC =>
      val r = Vpc
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.TrainingRepositoryAccessMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrainingRepositoryAccessMode =
      software.amazon.awssdk.services.sagemaker.model.TrainingRepositoryAccessMode.UNKNOWN_TO_SDK_VERSION
  }
  case object Platform
      extends zio.aws.sagemaker.model.TrainingRepositoryAccessMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrainingRepositoryAccessMode =
      software.amazon.awssdk.services.sagemaker.model.TrainingRepositoryAccessMode.PLATFORM
  }
  case object Vpc extends zio.aws.sagemaker.model.TrainingRepositoryAccessMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrainingRepositoryAccessMode =
      software.amazon.awssdk.services.sagemaker.model.TrainingRepositoryAccessMode.VPC
  }
}
