package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RecommendationJobPayloadConfig(
    samplePayloadUrl: Optional[String] = Optional.Absent,
    supportedContentTypes: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RecommendationJobPayloadConfig = {
    import RecommendationJobPayloadConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobPayloadConfig
      .builder()
      .optionallyWith(samplePayloadUrl.map(value => value: java.lang.String))(
        _.samplePayloadUrl
      )
      .optionallyWith(
        supportedContentTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.supportedContentTypes)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.RecommendationJobPayloadConfig.ReadOnly =
    zio.aws.sagemaker.model.RecommendationJobPayloadConfig.wrap(buildAwsValue())
}
object RecommendationJobPayloadConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobPayloadConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RecommendationJobPayloadConfig =
      zio.aws.sagemaker.model.RecommendationJobPayloadConfig(
        samplePayloadUrl.map(value => value),
        supportedContentTypes.map(value => value)
      )
    def samplePayloadUrl: Optional[String]
    def supportedContentTypes: Optional[List[String]]
    def getSamplePayloadUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("samplePayloadUrl", samplePayloadUrl)
    def getSupportedContentTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("supportedContentTypes", supportedContentTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobPayloadConfig
  ) extends zio.aws.sagemaker.model.RecommendationJobPayloadConfig.ReadOnly {
    override val samplePayloadUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.samplePayloadUrl())
      .map(value => value: String)
    override val supportedContentTypes: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedContentTypes())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobPayloadConfig
  ): zio.aws.sagemaker.model.RecommendationJobPayloadConfig.ReadOnly =
    new Wrapper(impl)
}
