package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ProjectSortOrder {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ProjectSortOrder
}
object ProjectSortOrder {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ProjectSortOrder
  ): zio.aws.sagemaker.model.ProjectSortOrder = value match {
    case software.amazon.awssdk.services.sagemaker.model.ProjectSortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ProjectSortOrder.ASCENDING =>
      val r = Ascending
      r
    case software.amazon.awssdk.services.sagemaker.model.ProjectSortOrder.DESCENDING =>
      val r = Descending
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ProjectSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProjectSortOrder =
      software.amazon.awssdk.services.sagemaker.model.ProjectSortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object Ascending extends zio.aws.sagemaker.model.ProjectSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProjectSortOrder =
      software.amazon.awssdk.services.sagemaker.model.ProjectSortOrder.ASCENDING
  }
  case object Descending extends zio.aws.sagemaker.model.ProjectSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProjectSortOrder =
      software.amazon.awssdk.services.sagemaker.model.ProjectSortOrder.DESCENDING
  }
}
