package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ImageVersionSortOrder {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.ImageVersionSortOrder
}
object ImageVersionSortOrder {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ImageVersionSortOrder
  ): zio.aws.sagemaker.model.ImageVersionSortOrder = value match {
    case software.amazon.awssdk.services.sagemaker.model.ImageVersionSortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageVersionSortOrder.ASCENDING =>
      val r = ASCENDING
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageVersionSortOrder.DESCENDING =>
      val r = DESCENDING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ImageVersionSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageVersionSortOrder =
      software.amazon.awssdk.services.sagemaker.model.ImageVersionSortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object ASCENDING extends zio.aws.sagemaker.model.ImageVersionSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageVersionSortOrder =
      software.amazon.awssdk.services.sagemaker.model.ImageVersionSortOrder.ASCENDING
  }
  case object DESCENDING extends zio.aws.sagemaker.model.ImageVersionSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageVersionSortOrder =
      software.amazon.awssdk.services.sagemaker.model.ImageVersionSortOrder.DESCENDING
  }
}
