package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class HyperParameterTuningJobConsumedResources(
    runtimeInSeconds: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobConsumedResources = {
    import HyperParameterTuningJobConsumedResources.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobConsumedResources
      .builder()
      .optionallyWith(runtimeInSeconds.map(value => value: java.lang.Integer))(
        _.runtimeInSeconds
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.HyperParameterTuningJobConsumedResources.ReadOnly =
    zio.aws.sagemaker.model.HyperParameterTuningJobConsumedResources
      .wrap(buildAwsValue())
}
object HyperParameterTuningJobConsumedResources {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobConsumedResources
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.HyperParameterTuningJobConsumedResources =
      zio.aws.sagemaker.model.HyperParameterTuningJobConsumedResources(
        runtimeInSeconds.map(value => value)
      )
    def runtimeInSeconds: Optional[Integer]
    def getRuntimeInSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("runtimeInSeconds", runtimeInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobConsumedResources
  ) extends zio.aws.sagemaker.model.HyperParameterTuningJobConsumedResources.ReadOnly {
    override val runtimeInSeconds: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.runtimeInSeconds())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobConsumedResources
  ): zio.aws.sagemaker.model.HyperParameterTuningJobConsumedResources.ReadOnly =
    new Wrapper(impl)
}
