package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.TrialComponentArn
import scala.jdk.CollectionConverters.*
final case class UpdateTrialComponentResponse(
    trialComponentArn: Optional[TrialComponentArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentResponse = {
    import UpdateTrialComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentResponse
      .builder()
      .optionallyWith(
        trialComponentArn.map(value =>
          TrialComponentArn.unwrap(value): java.lang.String
        )
      )(_.trialComponentArn)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.UpdateTrialComponentResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateTrialComponentResponse.wrap(buildAwsValue())
}
object UpdateTrialComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateTrialComponentResponse =
      zio.aws.sagemaker.model
        .UpdateTrialComponentResponse(trialComponentArn.map(value => value))
    def trialComponentArn: Optional[TrialComponentArn]
    def getTrialComponentArn: ZIO[Any, AwsError, TrialComponentArn] =
      AwsError.unwrapOptionField("trialComponentArn", trialComponentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentResponse
  ) extends zio.aws.sagemaker.model.UpdateTrialComponentResponse.ReadOnly {
    override val trialComponentArn: Optional[TrialComponentArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialComponentArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TrialComponentArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentResponse
  ): zio.aws.sagemaker.model.UpdateTrialComponentResponse.ReadOnly =
    new Wrapper(impl)
}
