package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  DisassociateNotebookInstanceAcceleratorTypes,
  NotebookInstanceVolumeSizeInGB,
  DisassociateAdditionalCodeRepositories,
  DisassociateNotebookInstanceLifecycleConfig,
  NotebookInstanceName,
  CodeRepositoryNameOrUrl,
  NotebookInstanceLifecycleConfigName,
  DisassociateDefaultCodeRepository
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateNotebookInstanceRequest(
    notebookInstanceName: NotebookInstanceName,
    instanceType: Optional[zio.aws.sagemaker.model.InstanceType] =
      Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    lifecycleConfigName: Optional[NotebookInstanceLifecycleConfigName] =
      Optional.Absent,
    disassociateLifecycleConfig: Optional[
      DisassociateNotebookInstanceLifecycleConfig
    ] = Optional.Absent,
    volumeSizeInGB: Optional[NotebookInstanceVolumeSizeInGB] = Optional.Absent,
    defaultCodeRepository: Optional[CodeRepositoryNameOrUrl] = Optional.Absent,
    additionalCodeRepositories: Optional[Iterable[CodeRepositoryNameOrUrl]] =
      Optional.Absent,
    acceleratorTypes: Optional[
      Iterable[zio.aws.sagemaker.model.NotebookInstanceAcceleratorType]
    ] = Optional.Absent,
    disassociateAcceleratorTypes: Optional[
      DisassociateNotebookInstanceAcceleratorTypes
    ] = Optional.Absent,
    disassociateDefaultCodeRepository: Optional[
      DisassociateDefaultCodeRepository
    ] = Optional.Absent,
    disassociateAdditionalCodeRepositories: Optional[
      DisassociateAdditionalCodeRepositories
    ] = Optional.Absent,
    rootAccess: Optional[zio.aws.sagemaker.model.RootAccess] = Optional.Absent,
    instanceMetadataServiceConfiguration: Optional[
      zio.aws.sagemaker.model.InstanceMetadataServiceConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceRequest = {
    import UpdateNotebookInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceRequest
      .builder()
      .notebookInstanceName(
        NotebookInstanceName.unwrap(notebookInstanceName): java.lang.String
      )
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        lifecycleConfigName.map(value =>
          NotebookInstanceLifecycleConfigName.unwrap(value): java.lang.String
        )
      )(_.lifecycleConfigName)
      .optionallyWith(
        disassociateLifecycleConfig.map(value =>
          DisassociateNotebookInstanceLifecycleConfig.unwrap(
            value
          ): java.lang.Boolean
        )
      )(_.disassociateLifecycleConfig)
      .optionallyWith(
        volumeSizeInGB.map(value =>
          NotebookInstanceVolumeSizeInGB.unwrap(value): Integer
        )
      )(_.volumeSizeInGB)
      .optionallyWith(
        defaultCodeRepository.map(value =>
          CodeRepositoryNameOrUrl.unwrap(value): java.lang.String
        )
      )(_.defaultCodeRepository)
      .optionallyWith(
        additionalCodeRepositories.map(value =>
          value.map { item =>
            CodeRepositoryNameOrUrl.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalCodeRepositories)
      .optionallyWith(
        acceleratorTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.acceleratorTypesWithStrings)
      .optionallyWith(
        disassociateAcceleratorTypes.map(value =>
          DisassociateNotebookInstanceAcceleratorTypes.unwrap(
            value
          ): java.lang.Boolean
        )
      )(_.disassociateAcceleratorTypes)
      .optionallyWith(
        disassociateDefaultCodeRepository.map(value =>
          DisassociateDefaultCodeRepository.unwrap(value): java.lang.Boolean
        )
      )(_.disassociateDefaultCodeRepository)
      .optionallyWith(
        disassociateAdditionalCodeRepositories.map(value =>
          DisassociateAdditionalCodeRepositories.unwrap(
            value
          ): java.lang.Boolean
        )
      )(_.disassociateAdditionalCodeRepositories)
      .optionallyWith(rootAccess.map(value => value.unwrap))(_.rootAccess)
      .optionallyWith(
        instanceMetadataServiceConfiguration.map(value => value.buildAwsValue())
      )(_.instanceMetadataServiceConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.UpdateNotebookInstanceRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateNotebookInstanceRequest.wrap(buildAwsValue())
}
object UpdateNotebookInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateNotebookInstanceRequest =
      zio.aws.sagemaker.model.UpdateNotebookInstanceRequest(
        notebookInstanceName,
        instanceType.map(value => value),
        roleArn.map(value => value),
        lifecycleConfigName.map(value => value),
        disassociateLifecycleConfig.map(value => value),
        volumeSizeInGB.map(value => value),
        defaultCodeRepository.map(value => value),
        additionalCodeRepositories.map(value => value),
        acceleratorTypes.map(value => value),
        disassociateAcceleratorTypes.map(value => value),
        disassociateDefaultCodeRepository.map(value => value),
        disassociateAdditionalCodeRepositories.map(value => value),
        rootAccess.map(value => value),
        instanceMetadataServiceConfiguration.map(value => value.asEditable)
      )
    def notebookInstanceName: NotebookInstanceName
    def instanceType: Optional[zio.aws.sagemaker.model.InstanceType]
    def roleArn: Optional[RoleArn]
    def lifecycleConfigName: Optional[NotebookInstanceLifecycleConfigName]
    def disassociateLifecycleConfig
        : Optional[DisassociateNotebookInstanceLifecycleConfig]
    def volumeSizeInGB: Optional[NotebookInstanceVolumeSizeInGB]
    def defaultCodeRepository: Optional[CodeRepositoryNameOrUrl]
    def additionalCodeRepositories: Optional[List[CodeRepositoryNameOrUrl]]
    def acceleratorTypes: Optional[
      List[zio.aws.sagemaker.model.NotebookInstanceAcceleratorType]
    ]
    def disassociateAcceleratorTypes
        : Optional[DisassociateNotebookInstanceAcceleratorTypes]
    def disassociateDefaultCodeRepository
        : Optional[DisassociateDefaultCodeRepository]
    def disassociateAdditionalCodeRepositories
        : Optional[DisassociateAdditionalCodeRepositories]
    def rootAccess: Optional[zio.aws.sagemaker.model.RootAccess]
    def instanceMetadataServiceConfiguration: Optional[
      zio.aws.sagemaker.model.InstanceMetadataServiceConfiguration.ReadOnly
    ]
    def getNotebookInstanceName: ZIO[Any, Nothing, NotebookInstanceName] =
      ZIO.succeed(notebookInstanceName)
    def getInstanceType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getLifecycleConfigName
        : ZIO[Any, AwsError, NotebookInstanceLifecycleConfigName] =
      AwsError.unwrapOptionField("lifecycleConfigName", lifecycleConfigName)
    def getDisassociateLifecycleConfig
        : ZIO[Any, AwsError, DisassociateNotebookInstanceLifecycleConfig] =
      AwsError.unwrapOptionField(
        "disassociateLifecycleConfig",
        disassociateLifecycleConfig
      )
    def getVolumeSizeInGB: ZIO[Any, AwsError, NotebookInstanceVolumeSizeInGB] =
      AwsError.unwrapOptionField("volumeSizeInGB", volumeSizeInGB)
    def getDefaultCodeRepository: ZIO[Any, AwsError, CodeRepositoryNameOrUrl] =
      AwsError.unwrapOptionField("defaultCodeRepository", defaultCodeRepository)
    def getAdditionalCodeRepositories
        : ZIO[Any, AwsError, List[CodeRepositoryNameOrUrl]] =
      AwsError.unwrapOptionField(
        "additionalCodeRepositories",
        additionalCodeRepositories
      )
    def getAcceleratorTypes: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.NotebookInstanceAcceleratorType
    ]] = AwsError.unwrapOptionField("acceleratorTypes", acceleratorTypes)
    def getDisassociateAcceleratorTypes
        : ZIO[Any, AwsError, DisassociateNotebookInstanceAcceleratorTypes] =
      AwsError.unwrapOptionField(
        "disassociateAcceleratorTypes",
        disassociateAcceleratorTypes
      )
    def getDisassociateDefaultCodeRepository
        : ZIO[Any, AwsError, DisassociateDefaultCodeRepository] =
      AwsError.unwrapOptionField(
        "disassociateDefaultCodeRepository",
        disassociateDefaultCodeRepository
      )
    def getDisassociateAdditionalCodeRepositories
        : ZIO[Any, AwsError, DisassociateAdditionalCodeRepositories] =
      AwsError.unwrapOptionField(
        "disassociateAdditionalCodeRepositories",
        disassociateAdditionalCodeRepositories
      )
    def getRootAccess: ZIO[Any, AwsError, zio.aws.sagemaker.model.RootAccess] =
      AwsError.unwrapOptionField("rootAccess", rootAccess)
    def getInstanceMetadataServiceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.InstanceMetadataServiceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "instanceMetadataServiceConfiguration",
      instanceMetadataServiceConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceRequest
  ) extends zio.aws.sagemaker.model.UpdateNotebookInstanceRequest.ReadOnly {
    override val notebookInstanceName: NotebookInstanceName =
      zio.aws.sagemaker.model.primitives
        .NotebookInstanceName(impl.notebookInstanceName())
    override val instanceType: Optional[zio.aws.sagemaker.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.sagemaker.model.InstanceType.wrap(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val lifecycleConfigName
        : Optional[NotebookInstanceLifecycleConfigName] = zio.aws.core.internal
      .optionalFromNullable(impl.lifecycleConfigName())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .NotebookInstanceLifecycleConfigName(value)
      )
    override val disassociateLifecycleConfig
        : Optional[DisassociateNotebookInstanceLifecycleConfig] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disassociateLifecycleConfig())
        .map(value =>
          zio.aws.sagemaker.model.primitives
            .DisassociateNotebookInstanceLifecycleConfig(value)
        )
    override val volumeSizeInGB: Optional[NotebookInstanceVolumeSizeInGB] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeSizeInGB())
        .map(value =>
          zio.aws.sagemaker.model.primitives
            .NotebookInstanceVolumeSizeInGB(value)
        )
    override val defaultCodeRepository: Optional[CodeRepositoryNameOrUrl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultCodeRepository())
        .map(value =>
          zio.aws.sagemaker.model.primitives.CodeRepositoryNameOrUrl(value)
        )
    override val additionalCodeRepositories
        : Optional[List[CodeRepositoryNameOrUrl]] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalCodeRepositories())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.CodeRepositoryNameOrUrl(item)
        }.toList
      )
    override val acceleratorTypes: Optional[
      List[zio.aws.sagemaker.model.NotebookInstanceAcceleratorType]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.acceleratorTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.NotebookInstanceAcceleratorType.wrap(item)
        }.toList
      )
    override val disassociateAcceleratorTypes
        : Optional[DisassociateNotebookInstanceAcceleratorTypes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disassociateAcceleratorTypes())
        .map(value =>
          zio.aws.sagemaker.model.primitives
            .DisassociateNotebookInstanceAcceleratorTypes(value)
        )
    override val disassociateDefaultCodeRepository
        : Optional[DisassociateDefaultCodeRepository] = zio.aws.core.internal
      .optionalFromNullable(impl.disassociateDefaultCodeRepository())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .DisassociateDefaultCodeRepository(value)
      )
    override val disassociateAdditionalCodeRepositories
        : Optional[DisassociateAdditionalCodeRepositories] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disassociateAdditionalCodeRepositories())
        .map(value =>
          zio.aws.sagemaker.model.primitives
            .DisassociateAdditionalCodeRepositories(value)
        )
    override val rootAccess: Optional[zio.aws.sagemaker.model.RootAccess] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rootAccess())
        .map(value => zio.aws.sagemaker.model.RootAccess.wrap(value))
    override val instanceMetadataServiceConfiguration: Optional[
      zio.aws.sagemaker.model.InstanceMetadataServiceConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceMetadataServiceConfiguration())
      .map(value =>
        zio.aws.sagemaker.model.InstanceMetadataServiceConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceRequest
  ): zio.aws.sagemaker.model.UpdateNotebookInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
