package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.InferenceExperimentArn
import scala.jdk.CollectionConverters.*
final case class UpdateInferenceExperimentResponse(
    inferenceExperimentArn: InferenceExperimentArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateInferenceExperimentResponse = {
    import UpdateInferenceExperimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateInferenceExperimentResponse
      .builder()
      .inferenceExperimentArn(
        InferenceExperimentArn.unwrap(inferenceExperimentArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.UpdateInferenceExperimentResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateInferenceExperimentResponse
      .wrap(buildAwsValue())
}
object UpdateInferenceExperimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateInferenceExperimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateInferenceExperimentResponse =
      zio.aws.sagemaker.model
        .UpdateInferenceExperimentResponse(inferenceExperimentArn)
    def inferenceExperimentArn: InferenceExperimentArn
    def getInferenceExperimentArn: ZIO[Any, Nothing, InferenceExperimentArn] =
      ZIO.succeed(inferenceExperimentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateInferenceExperimentResponse
  ) extends zio.aws.sagemaker.model.UpdateInferenceExperimentResponse.ReadOnly {
    override val inferenceExperimentArn: InferenceExperimentArn =
      zio.aws.sagemaker.model.primitives
        .InferenceExperimentArn(impl.inferenceExperimentArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateInferenceExperimentResponse
  ): zio.aws.sagemaker.model.UpdateInferenceExperimentResponse.ReadOnly =
    new Wrapper(impl)
}
