package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.FeatureGroupName
import scala.jdk.CollectionConverters.*
final case class UpdateFeatureGroupRequest(
    featureGroupName: FeatureGroupName,
    featureAdditions: Optional[
      Iterable[zio.aws.sagemaker.model.FeatureDefinition]
    ] = Optional.Absent,
    onlineStoreConfig: Optional[
      zio.aws.sagemaker.model.OnlineStoreConfigUpdate
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateFeatureGroupRequest = {
    import UpdateFeatureGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateFeatureGroupRequest
      .builder()
      .featureGroupName(
        FeatureGroupName.unwrap(featureGroupName): java.lang.String
      )
      .optionallyWith(
        featureAdditions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.featureAdditions)
      .optionallyWith(onlineStoreConfig.map(value => value.buildAwsValue()))(
        _.onlineStoreConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateFeatureGroupRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateFeatureGroupRequest.wrap(buildAwsValue())
}
object UpdateFeatureGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateFeatureGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateFeatureGroupRequest =
      zio.aws.sagemaker.model.UpdateFeatureGroupRequest(
        featureGroupName,
        featureAdditions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        onlineStoreConfig.map(value => value.asEditable)
      )
    def featureGroupName: FeatureGroupName
    def featureAdditions
        : Optional[List[zio.aws.sagemaker.model.FeatureDefinition.ReadOnly]]
    def onlineStoreConfig
        : Optional[zio.aws.sagemaker.model.OnlineStoreConfigUpdate.ReadOnly]
    def getFeatureGroupName: ZIO[Any, Nothing, FeatureGroupName] =
      ZIO.succeed(featureGroupName)
    def getFeatureAdditions: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.FeatureDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("featureAdditions", featureAdditions)
    def getOnlineStoreConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OnlineStoreConfigUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("onlineStoreConfig", onlineStoreConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateFeatureGroupRequest
  ) extends zio.aws.sagemaker.model.UpdateFeatureGroupRequest.ReadOnly {
    override val featureGroupName: FeatureGroupName =
      zio.aws.sagemaker.model.primitives
        .FeatureGroupName(impl.featureGroupName())
    override val featureAdditions
        : Optional[List[zio.aws.sagemaker.model.FeatureDefinition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureAdditions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.FeatureDefinition.wrap(item)
          }.toList
        )
    override val onlineStoreConfig
        : Optional[zio.aws.sagemaker.model.OnlineStoreConfigUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onlineStoreConfig())
        .map(value =>
          zio.aws.sagemaker.model.OnlineStoreConfigUpdate.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateFeatureGroupRequest
  ): zio.aws.sagemaker.model.UpdateFeatureGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
