package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EndpointName
import scala.jdk.CollectionConverters.*
final case class UpdateEndpointWeightsAndCapacitiesRequest(
    endpointName: EndpointName,
    desiredWeightsAndCapacities: Iterable[
      zio.aws.sagemaker.model.DesiredWeightAndCapacity
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesRequest = {
    import UpdateEndpointWeightsAndCapacitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesRequest
      .builder()
      .endpointName(EndpointName.unwrap(endpointName): java.lang.String)
      .desiredWeightsAndCapacities(desiredWeightsAndCapacities.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.UpdateEndpointWeightsAndCapacitiesRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateEndpointWeightsAndCapacitiesRequest
      .wrap(buildAwsValue())
}
object UpdateEndpointWeightsAndCapacitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.UpdateEndpointWeightsAndCapacitiesRequest =
      zio.aws.sagemaker.model.UpdateEndpointWeightsAndCapacitiesRequest(
        endpointName,
        desiredWeightsAndCapacities.map { item =>
          item.asEditable
        }
      )
    def endpointName: EndpointName
    def desiredWeightsAndCapacities
        : List[zio.aws.sagemaker.model.DesiredWeightAndCapacity.ReadOnly]
    def getEndpointName: ZIO[Any, Nothing, EndpointName] =
      ZIO.succeed(endpointName)
    def getDesiredWeightsAndCapacities: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.DesiredWeightAndCapacity.ReadOnly
    ]] = ZIO.succeed(desiredWeightsAndCapacities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesRequest
  ) extends zio.aws.sagemaker.model.UpdateEndpointWeightsAndCapacitiesRequest.ReadOnly {
    override val endpointName: EndpointName =
      zio.aws.sagemaker.model.primitives.EndpointName(impl.endpointName())
    override val desiredWeightsAndCapacities
        : List[zio.aws.sagemaker.model.DesiredWeightAndCapacity.ReadOnly] = impl
      .desiredWeightsAndCapacities()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.DesiredWeightAndCapacity.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesRequest
  ): zio.aws.sagemaker.model.UpdateEndpointWeightsAndCapacitiesRequest.ReadOnly =
    new Wrapper(impl)
}
