package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{EndpointConfigName, EndpointName}
import scala.jdk.CollectionConverters.*
final case class UpdateEndpointRequest(
    endpointName: EndpointName,
    endpointConfigName: EndpointConfigName,
    retainAllVariantProperties: Optional[Boolean] = Optional.Absent,
    excludeRetainedVariantProperties: Optional[
      Iterable[zio.aws.sagemaker.model.VariantProperty]
    ] = Optional.Absent,
    deploymentConfig: Optional[zio.aws.sagemaker.model.DeploymentConfig] =
      Optional.Absent,
    retainDeploymentConfig: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateEndpointRequest = {
    import UpdateEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateEndpointRequest
      .builder()
      .endpointName(EndpointName.unwrap(endpointName): java.lang.String)
      .endpointConfigName(
        EndpointConfigName.unwrap(endpointConfigName): java.lang.String
      )
      .optionallyWith(
        retainAllVariantProperties.map(value => value: java.lang.Boolean)
      )(_.retainAllVariantProperties)
      .optionallyWith(
        excludeRetainedVariantProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludeRetainedVariantProperties)
      .optionallyWith(deploymentConfig.map(value => value.buildAwsValue()))(
        _.deploymentConfig
      )
      .optionallyWith(
        retainDeploymentConfig.map(value => value: java.lang.Boolean)
      )(_.retainDeploymentConfig)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateEndpointRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateEndpointRequest.wrap(buildAwsValue())
}
object UpdateEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateEndpointRequest =
      zio.aws.sagemaker.model.UpdateEndpointRequest(
        endpointName,
        endpointConfigName,
        retainAllVariantProperties.map(value => value),
        excludeRetainedVariantProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        deploymentConfig.map(value => value.asEditable),
        retainDeploymentConfig.map(value => value)
      )
    def endpointName: EndpointName
    def endpointConfigName: EndpointConfigName
    def retainAllVariantProperties: Optional[Boolean]
    def excludeRetainedVariantProperties
        : Optional[List[zio.aws.sagemaker.model.VariantProperty.ReadOnly]]
    def deploymentConfig
        : Optional[zio.aws.sagemaker.model.DeploymentConfig.ReadOnly]
    def retainDeploymentConfig: Optional[Boolean]
    def getEndpointName: ZIO[Any, Nothing, EndpointName] =
      ZIO.succeed(endpointName)
    def getEndpointConfigName: ZIO[Any, Nothing, EndpointConfigName] =
      ZIO.succeed(endpointConfigName)
    def getRetainAllVariantProperties: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "retainAllVariantProperties",
        retainAllVariantProperties
      )
    def getExcludeRetainedVariantProperties: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.VariantProperty.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "excludeRetainedVariantProperties",
      excludeRetainedVariantProperties
    )
    def getDeploymentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DeploymentConfig.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentConfig", deploymentConfig)
    def getRetainDeploymentConfig: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("retainDeploymentConfig", retainDeploymentConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateEndpointRequest
  ) extends zio.aws.sagemaker.model.UpdateEndpointRequest.ReadOnly {
    override val endpointName: EndpointName =
      zio.aws.sagemaker.model.primitives.EndpointName(impl.endpointName())
    override val endpointConfigName: EndpointConfigName =
      zio.aws.sagemaker.model.primitives
        .EndpointConfigName(impl.endpointConfigName())
    override val retainAllVariantProperties: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retainAllVariantProperties())
        .map(value => value: Boolean)
    override val excludeRetainedVariantProperties
        : Optional[List[zio.aws.sagemaker.model.VariantProperty.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludeRetainedVariantProperties())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.VariantProperty.wrap(item)
          }.toList
        )
    override val deploymentConfig
        : Optional[zio.aws.sagemaker.model.DeploymentConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentConfig())
        .map(value => zio.aws.sagemaker.model.DeploymentConfig.wrap(value))
    override val retainDeploymentConfig: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retainDeploymentConfig())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateEndpointRequest
  ): zio.aws.sagemaker.model.UpdateEndpointRequest.ReadOnly = new Wrapper(impl)
}
