package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  InferenceExperimentStatusReason,
  ModelVariantName,
  InferenceExperimentName
}
import scala.jdk.CollectionConverters.*
final case class StopInferenceExperimentRequest(
    name: InferenceExperimentName,
    modelVariantActions: Map[
      ModelVariantName,
      zio.aws.sagemaker.model.ModelVariantAction
    ],
    desiredModelVariants: Optional[
      Iterable[zio.aws.sagemaker.model.ModelVariantConfig]
    ] = Optional.Absent,
    desiredState: Optional[
      zio.aws.sagemaker.model.InferenceExperimentStopDesiredState
    ] = Optional.Absent,
    reason: Optional[InferenceExperimentStatusReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StopInferenceExperimentRequest = {
    import StopInferenceExperimentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StopInferenceExperimentRequest
      .builder()
      .name(InferenceExperimentName.unwrap(name): java.lang.String)
      .modelVariantActionsWithStrings(
        modelVariantActions
          .map({ case (key, value) =>
            (ModelVariantName.unwrap(
              key
            ): java.lang.String) -> value.unwrap.toString
          })
          .asJava
      )
      .optionallyWith(
        desiredModelVariants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.desiredModelVariants)
      .optionallyWith(desiredState.map(value => value.unwrap))(_.desiredState)
      .optionallyWith(
        reason.map(value =>
          InferenceExperimentStatusReason.unwrap(value): java.lang.String
        )
      )(_.reason)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.StopInferenceExperimentRequest.ReadOnly =
    zio.aws.sagemaker.model.StopInferenceExperimentRequest.wrap(buildAwsValue())
}
object StopInferenceExperimentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StopInferenceExperimentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.StopInferenceExperimentRequest =
      zio.aws.sagemaker.model.StopInferenceExperimentRequest(
        name,
        modelVariantActions,
        desiredModelVariants.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        desiredState.map(value => value),
        reason.map(value => value)
      )
    def name: InferenceExperimentName
    def modelVariantActions
        : Map[ModelVariantName, zio.aws.sagemaker.model.ModelVariantAction]
    def desiredModelVariants
        : Optional[List[zio.aws.sagemaker.model.ModelVariantConfig.ReadOnly]]
    def desiredState
        : Optional[zio.aws.sagemaker.model.InferenceExperimentStopDesiredState]
    def reason: Optional[InferenceExperimentStatusReason]
    def getName: ZIO[Any, Nothing, InferenceExperimentName] = ZIO.succeed(name)
    def getModelVariantActions: ZIO[Any, Nothing, Map[
      ModelVariantName,
      zio.aws.sagemaker.model.ModelVariantAction
    ]] = ZIO.succeed(modelVariantActions)
    def getDesiredModelVariants: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ModelVariantConfig.ReadOnly
    ]] =
      AwsError.unwrapOptionField("desiredModelVariants", desiredModelVariants)
    def getDesiredState: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.InferenceExperimentStopDesiredState
    ] = AwsError.unwrapOptionField("desiredState", desiredState)
    def getReason: ZIO[Any, AwsError, InferenceExperimentStatusReason] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StopInferenceExperimentRequest
  ) extends zio.aws.sagemaker.model.StopInferenceExperimentRequest.ReadOnly {
    override val name: InferenceExperimentName =
      zio.aws.sagemaker.model.primitives.InferenceExperimentName(impl.name())
    override val modelVariantActions
        : Map[ModelVariantName, zio.aws.sagemaker.model.ModelVariantAction] =
      impl
        .modelVariantActions()
        .asScala
        .map({ case (key, value) =>
          zio.aws.sagemaker.model.primitives.ModelVariantName(
            key
          ) -> zio.aws.sagemaker.model.ModelVariantAction.wrap(value)
        })
        .toMap
    override val desiredModelVariants
        : Optional[List[zio.aws.sagemaker.model.ModelVariantConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredModelVariants())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.ModelVariantConfig.wrap(item)
          }.toList
        )
    override val desiredState: Optional[
      zio.aws.sagemaker.model.InferenceExperimentStopDesiredState
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredState())
      .map(value =>
        zio.aws.sagemaker.model.InferenceExperimentStopDesiredState.wrap(value)
      )
    override val reason: Optional[InferenceExperimentStatusReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reason())
        .map(value =>
          zio.aws.sagemaker.model.primitives
            .InferenceExperimentStatusReason(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StopInferenceExperimentRequest
  ): zio.aws.sagemaker.model.StopInferenceExperimentRequest.ReadOnly =
    new Wrapper(impl)
}
