package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait RecommendationJobSupportedEndpointType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.RecommendationJobSupportedEndpointType
}
object RecommendationJobSupportedEndpointType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.RecommendationJobSupportedEndpointType
  ): zio.aws.sagemaker.model.RecommendationJobSupportedEndpointType =
    value match {
      case software.amazon.awssdk.services.sagemaker.model.RecommendationJobSupportedEndpointType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.sagemaker.model.RecommendationJobSupportedEndpointType.REAL_TIME =>
        val r = RealTime
        r
      case software.amazon.awssdk.services.sagemaker.model.RecommendationJobSupportedEndpointType.SERVERLESS =>
        val r = Serverless
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.RecommendationJobSupportedEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecommendationJobSupportedEndpointType =
      software.amazon.awssdk.services.sagemaker.model.RecommendationJobSupportedEndpointType.UNKNOWN_TO_SDK_VERSION
  }
  case object RealTime
      extends zio.aws.sagemaker.model.RecommendationJobSupportedEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecommendationJobSupportedEndpointType =
      software.amazon.awssdk.services.sagemaker.model.RecommendationJobSupportedEndpointType.REAL_TIME
  }
  case object Serverless
      extends zio.aws.sagemaker.model.RecommendationJobSupportedEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecommendationJobSupportedEndpointType =
      software.amazon.awssdk.services.sagemaker.model.RecommendationJobSupportedEndpointType.SERVERLESS
  }
}
