package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.RecommendationJobDataInputConfig
import scala.jdk.CollectionConverters.*
final case class RecommendationJobContainerConfig(
    domain: Optional[String] = Optional.Absent,
    task: Optional[String] = Optional.Absent,
    framework: Optional[String] = Optional.Absent,
    frameworkVersion: Optional[String] = Optional.Absent,
    payloadConfig: Optional[
      zio.aws.sagemaker.model.RecommendationJobPayloadConfig
    ] = Optional.Absent,
    nearestModelName: Optional[String] = Optional.Absent,
    supportedInstanceTypes: Optional[Iterable[String]] = Optional.Absent,
    dataInputConfig: Optional[RecommendationJobDataInputConfig] =
      Optional.Absent,
    supportedEndpointType: Optional[
      zio.aws.sagemaker.model.RecommendationJobSupportedEndpointType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RecommendationJobContainerConfig = {
    import RecommendationJobContainerConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobContainerConfig
      .builder()
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(task.map(value => value: java.lang.String))(_.task)
      .optionallyWith(framework.map(value => value: java.lang.String))(
        _.framework
      )
      .optionallyWith(frameworkVersion.map(value => value: java.lang.String))(
        _.frameworkVersion
      )
      .optionallyWith(payloadConfig.map(value => value.buildAwsValue()))(
        _.payloadConfig
      )
      .optionallyWith(nearestModelName.map(value => value: java.lang.String))(
        _.nearestModelName
      )
      .optionallyWith(
        supportedInstanceTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.supportedInstanceTypes)
      .optionallyWith(
        dataInputConfig.map(value =>
          RecommendationJobDataInputConfig.unwrap(value): java.lang.String
        )
      )(_.dataInputConfig)
      .optionallyWith(supportedEndpointType.map(value => value.unwrap))(
        _.supportedEndpointType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.RecommendationJobContainerConfig.ReadOnly =
    zio.aws.sagemaker.model.RecommendationJobContainerConfig
      .wrap(buildAwsValue())
}
object RecommendationJobContainerConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobContainerConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RecommendationJobContainerConfig =
      zio.aws.sagemaker.model.RecommendationJobContainerConfig(
        domain.map(value => value),
        task.map(value => value),
        framework.map(value => value),
        frameworkVersion.map(value => value),
        payloadConfig.map(value => value.asEditable),
        nearestModelName.map(value => value),
        supportedInstanceTypes.map(value => value),
        dataInputConfig.map(value => value),
        supportedEndpointType.map(value => value)
      )
    def domain: Optional[String]
    def task: Optional[String]
    def framework: Optional[String]
    def frameworkVersion: Optional[String]
    def payloadConfig: Optional[
      zio.aws.sagemaker.model.RecommendationJobPayloadConfig.ReadOnly
    ]
    def nearestModelName: Optional[String]
    def supportedInstanceTypes: Optional[List[String]]
    def dataInputConfig: Optional[RecommendationJobDataInputConfig]
    def supportedEndpointType: Optional[
      zio.aws.sagemaker.model.RecommendationJobSupportedEndpointType
    ]
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getTask: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("task", task)
    def getFramework: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("framework", framework)
    def getFrameworkVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("frameworkVersion", frameworkVersion)
    def getPayloadConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RecommendationJobPayloadConfig.ReadOnly
    ] = AwsError.unwrapOptionField("payloadConfig", payloadConfig)
    def getNearestModelName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nearestModelName", nearestModelName)
    def getSupportedInstanceTypes: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("supportedInstanceTypes", supportedInstanceTypes)
    def getDataInputConfig
        : ZIO[Any, AwsError, RecommendationJobDataInputConfig] =
      AwsError.unwrapOptionField("dataInputConfig", dataInputConfig)
    def getSupportedEndpointType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RecommendationJobSupportedEndpointType
    ] =
      AwsError.unwrapOptionField("supportedEndpointType", supportedEndpointType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobContainerConfig
  ) extends zio.aws.sagemaker.model.RecommendationJobContainerConfig.ReadOnly {
    override val domain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => value: String)
    override val task: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.task())
      .map(value => value: String)
    override val framework: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.framework())
      .map(value => value: String)
    override val frameworkVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.frameworkVersion())
      .map(value => value: String)
    override val payloadConfig: Optional[
      zio.aws.sagemaker.model.RecommendationJobPayloadConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.payloadConfig())
      .map(value =>
        zio.aws.sagemaker.model.RecommendationJobPayloadConfig.wrap(value)
      )
    override val nearestModelName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nearestModelName())
      .map(value => value: String)
    override val supportedInstanceTypes: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedInstanceTypes())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val dataInputConfig: Optional[RecommendationJobDataInputConfig] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataInputConfig())
        .map(value =>
          zio.aws.sagemaker.model.primitives
            .RecommendationJobDataInputConfig(value)
        )
    override val supportedEndpointType: Optional[
      zio.aws.sagemaker.model.RecommendationJobSupportedEndpointType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.supportedEndpointType())
      .map(value =>
        zio.aws.sagemaker.model.RecommendationJobSupportedEndpointType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobContainerConfig
  ): zio.aws.sagemaker.model.RecommendationJobContainerConfig.ReadOnly =
    new Wrapper(impl)
}
