package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  PipelineExecutionName,
  PipelineExecutionFailureReason,
  Timestamp,
  PipelineArn,
  PipelineExecutionArn,
  PipelineExecutionDescription
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class PipelineExecution(
    pipelineArn: Optional[PipelineArn] = Optional.Absent,
    pipelineExecutionArn: Optional[PipelineExecutionArn] = Optional.Absent,
    pipelineExecutionDisplayName: Optional[PipelineExecutionName] =
      Optional.Absent,
    pipelineExecutionStatus: Optional[
      zio.aws.sagemaker.model.PipelineExecutionStatus
    ] = Optional.Absent,
    pipelineExecutionDescription: Optional[PipelineExecutionDescription] =
      Optional.Absent,
    pipelineExperimentConfig: Optional[
      zio.aws.sagemaker.model.PipelineExperimentConfig
    ] = Optional.Absent,
    failureReason: Optional[PipelineExecutionFailureReason] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[zio.aws.sagemaker.model.UserContext] = Optional.Absent,
    lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext] =
      Optional.Absent,
    parallelismConfiguration: Optional[
      zio.aws.sagemaker.model.ParallelismConfiguration
    ] = Optional.Absent,
    pipelineParameters: Optional[Iterable[zio.aws.sagemaker.model.Parameter]] =
      Optional.Absent,
    selectiveExecutionConfig: Optional[
      zio.aws.sagemaker.model.SelectiveExecutionConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.PipelineExecution = {
    import PipelineExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.PipelineExecution
      .builder()
      .optionallyWith(
        pipelineArn.map(value => PipelineArn.unwrap(value): java.lang.String)
      )(_.pipelineArn)
      .optionallyWith(
        pipelineExecutionArn.map(value =>
          PipelineExecutionArn.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionArn)
      .optionallyWith(
        pipelineExecutionDisplayName.map(value =>
          PipelineExecutionName.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionDisplayName)
      .optionallyWith(pipelineExecutionStatus.map(value => value.unwrap))(
        _.pipelineExecutionStatus
      )
      .optionallyWith(
        pipelineExecutionDescription.map(value =>
          PipelineExecutionDescription.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionDescription)
      .optionallyWith(
        pipelineExperimentConfig.map(value => value.buildAwsValue())
      )(_.pipelineExperimentConfig)
      .optionallyWith(
        failureReason.map(value =>
          PipelineExecutionFailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .optionallyWith(
        parallelismConfiguration.map(value => value.buildAwsValue())
      )(_.parallelismConfiguration)
      .optionallyWith(
        pipelineParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pipelineParameters)
      .optionallyWith(
        selectiveExecutionConfig.map(value => value.buildAwsValue())
      )(_.selectiveExecutionConfig)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.PipelineExecution.ReadOnly =
    zio.aws.sagemaker.model.PipelineExecution.wrap(buildAwsValue())
}
object PipelineExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.PipelineExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.PipelineExecution =
      zio.aws.sagemaker.model.PipelineExecution(
        pipelineArn.map(value => value),
        pipelineExecutionArn.map(value => value),
        pipelineExecutionDisplayName.map(value => value),
        pipelineExecutionStatus.map(value => value),
        pipelineExecutionDescription.map(value => value),
        pipelineExperimentConfig.map(value => value.asEditable),
        failureReason.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        createdBy.map(value => value.asEditable),
        lastModifiedBy.map(value => value.asEditable),
        parallelismConfiguration.map(value => value.asEditable),
        pipelineParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        selectiveExecutionConfig.map(value => value.asEditable)
      )
    def pipelineArn: Optional[PipelineArn]
    def pipelineExecutionArn: Optional[PipelineExecutionArn]
    def pipelineExecutionDisplayName: Optional[PipelineExecutionName]
    def pipelineExecutionStatus
        : Optional[zio.aws.sagemaker.model.PipelineExecutionStatus]
    def pipelineExecutionDescription: Optional[PipelineExecutionDescription]
    def pipelineExperimentConfig
        : Optional[zio.aws.sagemaker.model.PipelineExperimentConfig.ReadOnly]
    def failureReason: Optional[PipelineExecutionFailureReason]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def createdBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def parallelismConfiguration
        : Optional[zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly]
    def pipelineParameters
        : Optional[List[zio.aws.sagemaker.model.Parameter.ReadOnly]]
    def selectiveExecutionConfig
        : Optional[zio.aws.sagemaker.model.SelectiveExecutionConfig.ReadOnly]
    def getPipelineArn: ZIO[Any, AwsError, PipelineArn] =
      AwsError.unwrapOptionField("pipelineArn", pipelineArn)
    def getPipelineExecutionArn: ZIO[Any, AwsError, PipelineExecutionArn] =
      AwsError.unwrapOptionField("pipelineExecutionArn", pipelineExecutionArn)
    def getPipelineExecutionDisplayName
        : ZIO[Any, AwsError, PipelineExecutionName] =
      AwsError.unwrapOptionField(
        "pipelineExecutionDisplayName",
        pipelineExecutionDisplayName
      )
    def getPipelineExecutionStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.PipelineExecutionStatus] =
      AwsError.unwrapOptionField(
        "pipelineExecutionStatus",
        pipelineExecutionStatus
      )
    def getPipelineExecutionDescription
        : ZIO[Any, AwsError, PipelineExecutionDescription] =
      AwsError.unwrapOptionField(
        "pipelineExecutionDescription",
        pipelineExecutionDescription
      )
    def getPipelineExperimentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.PipelineExperimentConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pipelineExperimentConfig",
      pipelineExperimentConfig
    )
    def getFailureReason: ZIO[Any, AwsError, PipelineExecutionFailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getParallelismConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "parallelismConfiguration",
      parallelismConfiguration
    )
    def getPipelineParameters
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("pipelineParameters", pipelineParameters)
    def getSelectiveExecutionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.SelectiveExecutionConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "selectiveExecutionConfig",
      selectiveExecutionConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.PipelineExecution
  ) extends zio.aws.sagemaker.model.PipelineExecution.ReadOnly {
    override val pipelineArn: Optional[PipelineArn] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineArn())
      .map(value => zio.aws.sagemaker.model.primitives.PipelineArn(value))
    override val pipelineExecutionArn: Optional[PipelineExecutionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineExecutionArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.PipelineExecutionArn(value)
        )
    override val pipelineExecutionDisplayName: Optional[PipelineExecutionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineExecutionDisplayName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.PipelineExecutionName(value)
        )
    override val pipelineExecutionStatus
        : Optional[zio.aws.sagemaker.model.PipelineExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineExecutionStatus())
        .map(value =>
          zio.aws.sagemaker.model.PipelineExecutionStatus.wrap(value)
        )
    override val pipelineExecutionDescription
        : Optional[PipelineExecutionDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineExecutionDescription())
      .map(value =>
        zio.aws.sagemaker.model.primitives.PipelineExecutionDescription(value)
      )
    override val pipelineExperimentConfig
        : Optional[zio.aws.sagemaker.model.PipelineExperimentConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineExperimentConfig())
        .map(value =>
          zio.aws.sagemaker.model.PipelineExperimentConfig.wrap(value)
        )
    override val failureReason: Optional[PipelineExecutionFailureReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReason())
        .map(value =>
          zio.aws.sagemaker.model.primitives
            .PipelineExecutionFailureReason(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val lastModifiedBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val parallelismConfiguration
        : Optional[zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parallelismConfiguration())
        .map(value =>
          zio.aws.sagemaker.model.ParallelismConfiguration.wrap(value)
        )
    override val pipelineParameters
        : Optional[List[zio.aws.sagemaker.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Parameter.wrap(item)
          }.toList
        )
    override val selectiveExecutionConfig
        : Optional[zio.aws.sagemaker.model.SelectiveExecutionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selectiveExecutionConfig())
        .map(value =>
          zio.aws.sagemaker.model.SelectiveExecutionConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.PipelineExecution
  ): zio.aws.sagemaker.model.PipelineExecution.ReadOnly = new Wrapper(impl)
}
