package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait OutputCompressionType {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.OutputCompressionType
}
object OutputCompressionType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.OutputCompressionType
  ): zio.aws.sagemaker.model.OutputCompressionType = value match {
    case software.amazon.awssdk.services.sagemaker.model.OutputCompressionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.OutputCompressionType.GZIP =>
      val r = GZIP
      r
    case software.amazon.awssdk.services.sagemaker.model.OutputCompressionType.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.OutputCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.OutputCompressionType =
      software.amazon.awssdk.services.sagemaker.model.OutputCompressionType.UNKNOWN_TO_SDK_VERSION
  }
  case object GZIP extends zio.aws.sagemaker.model.OutputCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.OutputCompressionType =
      software.amazon.awssdk.services.sagemaker.model.OutputCompressionType.GZIP
  }
  case object NONE extends zio.aws.sagemaker.model.OutputCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.OutputCompressionType =
      software.amazon.awssdk.services.sagemaker.model.OutputCompressionType.NONE
  }
}
