package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MultiModelConfig(
    modelCacheSetting: Optional[zio.aws.sagemaker.model.ModelCacheSetting] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MultiModelConfig = {
    import MultiModelConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MultiModelConfig
      .builder()
      .optionallyWith(modelCacheSetting.map(value => value.unwrap))(
        _.modelCacheSetting
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MultiModelConfig.ReadOnly =
    zio.aws.sagemaker.model.MultiModelConfig.wrap(buildAwsValue())
}
object MultiModelConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MultiModelConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MultiModelConfig =
      zio.aws.sagemaker.model
        .MultiModelConfig(modelCacheSetting.map(value => value))
    def modelCacheSetting: Optional[zio.aws.sagemaker.model.ModelCacheSetting]
    def getModelCacheSetting
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelCacheSetting] =
      AwsError.unwrapOptionField("modelCacheSetting", modelCacheSetting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MultiModelConfig
  ) extends zio.aws.sagemaker.model.MultiModelConfig.ReadOnly {
    override val modelCacheSetting
        : Optional[zio.aws.sagemaker.model.ModelCacheSetting] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelCacheSetting())
        .map(value => zio.aws.sagemaker.model.ModelCacheSetting.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MultiModelConfig
  ): zio.aws.sagemaker.model.MultiModelConfig.ReadOnly = new Wrapper(impl)
}
