package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ModelDataSource(
    s3DataSource: zio.aws.sagemaker.model.S3ModelDataSource
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelDataSource = {
    import ModelDataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelDataSource
      .builder()
      .s3DataSource(s3DataSource.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelDataSource.ReadOnly =
    zio.aws.sagemaker.model.ModelDataSource.wrap(buildAwsValue())
}
object ModelDataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelDataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelDataSource =
      zio.aws.sagemaker.model.ModelDataSource(s3DataSource.asEditable)
    def s3DataSource: zio.aws.sagemaker.model.S3ModelDataSource.ReadOnly
    def getS3DataSource: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.S3ModelDataSource.ReadOnly
    ] = ZIO.succeed(s3DataSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelDataSource
  ) extends zio.aws.sagemaker.model.ModelDataSource.ReadOnly {
    override val s3DataSource
        : zio.aws.sagemaker.model.S3ModelDataSource.ReadOnly =
      zio.aws.sagemaker.model.S3ModelDataSource.wrap(impl.s3DataSource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelDataSource
  ): zio.aws.sagemaker.model.ModelDataSource.ReadOnly = new Wrapper(impl)
}
