package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ModelCardStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ModelCardStatus
}
object ModelCardStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ModelCardStatus
  ): zio.aws.sagemaker.model.ModelCardStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.ModelCardStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelCardStatus.DRAFT =>
      val r = Draft
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelCardStatus.PENDING_REVIEW =>
      val r = PendingReview
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelCardStatus.APPROVED =>
      val r = Approved
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelCardStatus.ARCHIVED =>
      val r = Archived
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ModelCardStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCardStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelCardStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Draft extends zio.aws.sagemaker.model.ModelCardStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCardStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelCardStatus.DRAFT
  }
  case object PendingReview extends zio.aws.sagemaker.model.ModelCardStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCardStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelCardStatus.PENDING_REVIEW
  }
  case object Approved extends zio.aws.sagemaker.model.ModelCardStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCardStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelCardStatus.APPROVED
  }
  case object Archived extends zio.aws.sagemaker.model.ModelCardStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCardStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelCardStatus.ARCHIVED
  }
}
