package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ModelCardExportJobStatus {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobStatus
}
object ModelCardExportJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobStatus
  ): zio.aws.sagemaker.model.ModelCardExportJobStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ModelCardExportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress
      extends zio.aws.sagemaker.model.ModelCardExportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobStatus.IN_PROGRESS
  }
  case object Completed
      extends zio.aws.sagemaker.model.ModelCardExportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobStatus.COMPLETED
  }
  case object Failed extends zio.aws.sagemaker.model.ModelCardExportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobStatus.FAILED
  }
}
