package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListHyperParameterTuningJobsResponse(
    hyperParameterTuningJobSummaries: Iterable[
      zio.aws.sagemaker.model.HyperParameterTuningJobSummary
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsResponse = {
    import ListHyperParameterTuningJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsResponse
      .builder()
      .hyperParameterTuningJobSummaries(hyperParameterTuningJobSummaries.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListHyperParameterTuningJobsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListHyperParameterTuningJobsResponse
      .wrap(buildAwsValue())
}
object ListHyperParameterTuningJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ListHyperParameterTuningJobsResponse =
      zio.aws.sagemaker.model.ListHyperParameterTuningJobsResponse(
        hyperParameterTuningJobSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def hyperParameterTuningJobSummaries
        : List[zio.aws.sagemaker.model.HyperParameterTuningJobSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getHyperParameterTuningJobSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.HyperParameterTuningJobSummary.ReadOnly
    ]] = ZIO.succeed(hyperParameterTuningJobSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsResponse
  ) extends zio.aws.sagemaker.model.ListHyperParameterTuningJobsResponse.ReadOnly {
    override val hyperParameterTuningJobSummaries: List[
      zio.aws.sagemaker.model.HyperParameterTuningJobSummary.ReadOnly
    ] = impl
      .hyperParameterTuningJobSummaries()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.HyperParameterTuningJobSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsResponse
  ): zio.aws.sagemaker.model.ListHyperParameterTuningJobsResponse.ReadOnly =
    new Wrapper(impl)
}
