package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait LabelingJobStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus
}
object LabelingJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus
  ): zio.aws.sagemaker.model.LabelingJobStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus.INITIALIZING =>
      val r = Initializing
      r
    case software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus.STOPPED =>
      val r = Stopped
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.LabelingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Initializing extends zio.aws.sagemaker.model.LabelingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus.INITIALIZING
  }
  case object InProgress extends zio.aws.sagemaker.model.LabelingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus.IN_PROGRESS
  }
  case object Completed extends zio.aws.sagemaker.model.LabelingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus.COMPLETED
  }
  case object Failed extends zio.aws.sagemaker.model.LabelingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus.FAILED
  }
  case object Stopping extends zio.aws.sagemaker.model.LabelingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus.STOPPING
  }
  case object Stopped extends zio.aws.sagemaker.model.LabelingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus.STOPPED
  }
}
