package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  FailureReason,
  Timestamp,
  HyperParameterTuningJobArn,
  HyperParameterTuningJobName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class HyperParameterTuningJobSearchEntity(
    hyperParameterTuningJobName: Optional[HyperParameterTuningJobName] =
      Optional.Absent,
    hyperParameterTuningJobArn: Optional[HyperParameterTuningJobArn] =
      Optional.Absent,
    hyperParameterTuningJobConfig: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobConfig
    ] = Optional.Absent,
    trainingJobDefinition: Optional[
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition
    ] = Optional.Absent,
    trainingJobDefinitions: Optional[
      Iterable[zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition]
    ] = Optional.Absent,
    hyperParameterTuningJobStatus: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobStatus
    ] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    hyperParameterTuningEndTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    trainingJobStatusCounters: Optional[
      zio.aws.sagemaker.model.TrainingJobStatusCounters
    ] = Optional.Absent,
    objectiveStatusCounters: Optional[
      zio.aws.sagemaker.model.ObjectiveStatusCounters
    ] = Optional.Absent,
    bestTrainingJob: Optional[
      zio.aws.sagemaker.model.HyperParameterTrainingJobSummary
    ] = Optional.Absent,
    overallBestTrainingJob: Optional[
      zio.aws.sagemaker.model.HyperParameterTrainingJobSummary
    ] = Optional.Absent,
    warmStartConfig: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig
    ] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent,
    tuningJobCompletionDetails: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobCompletionDetails
    ] = Optional.Absent,
    consumedResources: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobConsumedResources
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobSearchEntity = {
    import HyperParameterTuningJobSearchEntity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobSearchEntity
      .builder()
      .optionallyWith(
        hyperParameterTuningJobName.map(value =>
          HyperParameterTuningJobName.unwrap(value): java.lang.String
        )
      )(_.hyperParameterTuningJobName)
      .optionallyWith(
        hyperParameterTuningJobArn.map(value =>
          HyperParameterTuningJobArn.unwrap(value): java.lang.String
        )
      )(_.hyperParameterTuningJobArn)
      .optionallyWith(
        hyperParameterTuningJobConfig.map(value => value.buildAwsValue())
      )(_.hyperParameterTuningJobConfig)
      .optionallyWith(
        trainingJobDefinition.map(value => value.buildAwsValue())
      )(_.trainingJobDefinition)
      .optionallyWith(
        trainingJobDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.trainingJobDefinitions)
      .optionallyWith(hyperParameterTuningJobStatus.map(value => value.unwrap))(
        _.hyperParameterTuningJobStatus
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        hyperParameterTuningEndTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.hyperParameterTuningEndTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        trainingJobStatusCounters.map(value => value.buildAwsValue())
      )(_.trainingJobStatusCounters)
      .optionallyWith(
        objectiveStatusCounters.map(value => value.buildAwsValue())
      )(_.objectiveStatusCounters)
      .optionallyWith(bestTrainingJob.map(value => value.buildAwsValue()))(
        _.bestTrainingJob
      )
      .optionallyWith(
        overallBestTrainingJob.map(value => value.buildAwsValue())
      )(_.overallBestTrainingJob)
      .optionallyWith(warmStartConfig.map(value => value.buildAwsValue()))(
        _.warmStartConfig
      )
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        tuningJobCompletionDetails.map(value => value.buildAwsValue())
      )(_.tuningJobCompletionDetails)
      .optionallyWith(consumedResources.map(value => value.buildAwsValue()))(
        _.consumedResources
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.HyperParameterTuningJobSearchEntity.ReadOnly =
    zio.aws.sagemaker.model.HyperParameterTuningJobSearchEntity
      .wrap(buildAwsValue())
}
object HyperParameterTuningJobSearchEntity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobSearchEntity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.HyperParameterTuningJobSearchEntity =
      zio.aws.sagemaker.model.HyperParameterTuningJobSearchEntity(
        hyperParameterTuningJobName.map(value => value),
        hyperParameterTuningJobArn.map(value => value),
        hyperParameterTuningJobConfig.map(value => value.asEditable),
        trainingJobDefinition.map(value => value.asEditable),
        trainingJobDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hyperParameterTuningJobStatus.map(value => value),
        creationTime.map(value => value),
        hyperParameterTuningEndTime.map(value => value),
        lastModifiedTime.map(value => value),
        trainingJobStatusCounters.map(value => value.asEditable),
        objectiveStatusCounters.map(value => value.asEditable),
        bestTrainingJob.map(value => value.asEditable),
        overallBestTrainingJob.map(value => value.asEditable),
        warmStartConfig.map(value => value.asEditable),
        failureReason.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tuningJobCompletionDetails.map(value => value.asEditable),
        consumedResources.map(value => value.asEditable)
      )
    def hyperParameterTuningJobName: Optional[HyperParameterTuningJobName]
    def hyperParameterTuningJobArn: Optional[HyperParameterTuningJobArn]
    def hyperParameterTuningJobConfig: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobConfig.ReadOnly
    ]
    def trainingJobDefinition: Optional[
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly
    ]
    def trainingJobDefinitions: Optional[
      List[zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly]
    ]
    def hyperParameterTuningJobStatus
        : Optional[zio.aws.sagemaker.model.HyperParameterTuningJobStatus]
    def creationTime: Optional[Timestamp]
    def hyperParameterTuningEndTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def trainingJobStatusCounters
        : Optional[zio.aws.sagemaker.model.TrainingJobStatusCounters.ReadOnly]
    def objectiveStatusCounters
        : Optional[zio.aws.sagemaker.model.ObjectiveStatusCounters.ReadOnly]
    def bestTrainingJob: Optional[
      zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.ReadOnly
    ]
    def overallBestTrainingJob: Optional[
      zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.ReadOnly
    ]
    def warmStartConfig: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig.ReadOnly
    ]
    def failureReason: Optional[FailureReason]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def tuningJobCompletionDetails: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobCompletionDetails.ReadOnly
    ]
    def consumedResources: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobConsumedResources.ReadOnly
    ]
    def getHyperParameterTuningJobName
        : ZIO[Any, AwsError, HyperParameterTuningJobName] =
      AwsError.unwrapOptionField(
        "hyperParameterTuningJobName",
        hyperParameterTuningJobName
      )
    def getHyperParameterTuningJobArn
        : ZIO[Any, AwsError, HyperParameterTuningJobArn] =
      AwsError.unwrapOptionField(
        "hyperParameterTuningJobArn",
        hyperParameterTuningJobArn
      )
    def getHyperParameterTuningJobConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTuningJobConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "hyperParameterTuningJobConfig",
      hyperParameterTuningJobConfig
    )
    def getTrainingJobDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly
    ] =
      AwsError.unwrapOptionField("trainingJobDefinition", trainingJobDefinition)
    def getTrainingJobDefinitions: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "trainingJobDefinitions",
      trainingJobDefinitions
    )
    def getHyperParameterTuningJobStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTuningJobStatus
    ] = AwsError.unwrapOptionField(
      "hyperParameterTuningJobStatus",
      hyperParameterTuningJobStatus
    )
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getHyperParameterTuningEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "hyperParameterTuningEndTime",
        hyperParameterTuningEndTime
      )
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getTrainingJobStatusCounters: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TrainingJobStatusCounters.ReadOnly
    ] = AwsError.unwrapOptionField(
      "trainingJobStatusCounters",
      trainingJobStatusCounters
    )
    def getObjectiveStatusCounters: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ObjectiveStatusCounters.ReadOnly
    ] = AwsError.unwrapOptionField(
      "objectiveStatusCounters",
      objectiveStatusCounters
    )
    def getBestTrainingJob: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.ReadOnly
    ] = AwsError.unwrapOptionField("bestTrainingJob", bestTrainingJob)
    def getOverallBestTrainingJob: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "overallBestTrainingJob",
      overallBestTrainingJob
    )
    def getWarmStartConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig.ReadOnly
    ] = AwsError.unwrapOptionField("warmStartConfig", warmStartConfig)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTuningJobCompletionDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTuningJobCompletionDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "tuningJobCompletionDetails",
      tuningJobCompletionDetails
    )
    def getConsumedResources: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTuningJobConsumedResources.ReadOnly
    ] = AwsError.unwrapOptionField("consumedResources", consumedResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobSearchEntity
  ) extends zio.aws.sagemaker.model.HyperParameterTuningJobSearchEntity.ReadOnly {
    override val hyperParameterTuningJobName
        : Optional[HyperParameterTuningJobName] = zio.aws.core.internal
      .optionalFromNullable(impl.hyperParameterTuningJobName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.HyperParameterTuningJobName(value)
      )
    override val hyperParameterTuningJobArn
        : Optional[HyperParameterTuningJobArn] = zio.aws.core.internal
      .optionalFromNullable(impl.hyperParameterTuningJobArn())
      .map(value =>
        zio.aws.sagemaker.model.primitives.HyperParameterTuningJobArn(value)
      )
    override val hyperParameterTuningJobConfig: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.hyperParameterTuningJobConfig())
      .map(value =>
        zio.aws.sagemaker.model.HyperParameterTuningJobConfig.wrap(value)
      )
    override val trainingJobDefinition: Optional[
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingJobDefinition())
      .map(value =>
        zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.wrap(value)
      )
    override val trainingJobDefinitions: Optional[
      List[zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingJobDefinitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.wrap(item)
        }.toList
      )
    override val hyperParameterTuningJobStatus
        : Optional[zio.aws.sagemaker.model.HyperParameterTuningJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hyperParameterTuningJobStatus())
        .map(value =>
          zio.aws.sagemaker.model.HyperParameterTuningJobStatus.wrap(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val hyperParameterTuningEndTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hyperParameterTuningEndTime())
        .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val trainingJobStatusCounters
        : Optional[zio.aws.sagemaker.model.TrainingJobStatusCounters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingJobStatusCounters())
        .map(value =>
          zio.aws.sagemaker.model.TrainingJobStatusCounters.wrap(value)
        )
    override val objectiveStatusCounters
        : Optional[zio.aws.sagemaker.model.ObjectiveStatusCounters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectiveStatusCounters())
        .map(value =>
          zio.aws.sagemaker.model.ObjectiveStatusCounters.wrap(value)
        )
    override val bestTrainingJob: Optional[
      zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bestTrainingJob())
      .map(value =>
        zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.wrap(value)
      )
    override val overallBestTrainingJob: Optional[
      zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.overallBestTrainingJob())
      .map(value =>
        zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.wrap(value)
      )
    override val warmStartConfig: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.warmStartConfig())
      .map(value =>
        zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig
          .wrap(value)
      )
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val tuningJobCompletionDetails: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobCompletionDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tuningJobCompletionDetails())
      .map(value =>
        zio.aws.sagemaker.model.HyperParameterTuningJobCompletionDetails
          .wrap(value)
      )
    override val consumedResources: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobConsumedResources.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.consumedResources())
      .map(value =>
        zio.aws.sagemaker.model.HyperParameterTuningJobConsumedResources
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobSearchEntity
  ): zio.aws.sagemaker.model.HyperParameterTuningJobSearchEntity.ReadOnly =
    new Wrapper(impl)
}
