package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  HubSearchKeyword,
  Timestamp,
  HubDescription,
  HubDisplayName,
  HubName,
  HubArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class HubInfo(
    hubName: HubName,
    hubArn: HubArn,
    hubDisplayName: Optional[HubDisplayName] = Optional.Absent,
    hubDescription: Optional[HubDescription] = Optional.Absent,
    hubSearchKeywords: Optional[Iterable[HubSearchKeyword]] = Optional.Absent,
    hubStatus: zio.aws.sagemaker.model.HubStatus,
    creationTime: Timestamp,
    lastModifiedTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HubInfo = {
    import HubInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HubInfo
      .builder()
      .hubName(HubName.unwrap(hubName): java.lang.String)
      .hubArn(HubArn.unwrap(hubArn): java.lang.String)
      .optionallyWith(
        hubDisplayName.map(value =>
          HubDisplayName.unwrap(value): java.lang.String
        )
      )(_.hubDisplayName)
      .optionallyWith(
        hubDescription.map(value =>
          HubDescription.unwrap(value): java.lang.String
        )
      )(_.hubDescription)
      .optionallyWith(
        hubSearchKeywords.map(value =>
          value.map { item =>
            HubSearchKeyword.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.hubSearchKeywords)
      .hubStatus(hubStatus.unwrap)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.HubInfo.ReadOnly =
    zio.aws.sagemaker.model.HubInfo.wrap(buildAwsValue())
}
object HubInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sagemaker.model.HubInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.HubInfo =
      zio.aws.sagemaker.model.HubInfo(
        hubName,
        hubArn,
        hubDisplayName.map(value => value),
        hubDescription.map(value => value),
        hubSearchKeywords.map(value => value),
        hubStatus,
        creationTime,
        lastModifiedTime
      )
    def hubName: HubName
    def hubArn: HubArn
    def hubDisplayName: Optional[HubDisplayName]
    def hubDescription: Optional[HubDescription]
    def hubSearchKeywords: Optional[List[HubSearchKeyword]]
    def hubStatus: zio.aws.sagemaker.model.HubStatus
    def creationTime: Timestamp
    def lastModifiedTime: Timestamp
    def getHubName: ZIO[Any, Nothing, HubName] = ZIO.succeed(hubName)
    def getHubArn: ZIO[Any, Nothing, HubArn] = ZIO.succeed(hubArn)
    def getHubDisplayName: ZIO[Any, AwsError, HubDisplayName] =
      AwsError.unwrapOptionField("hubDisplayName", hubDisplayName)
    def getHubDescription: ZIO[Any, AwsError, HubDescription] =
      AwsError.unwrapOptionField("hubDescription", hubDescription)
    def getHubSearchKeywords: ZIO[Any, AwsError, List[HubSearchKeyword]] =
      AwsError.unwrapOptionField("hubSearchKeywords", hubSearchKeywords)
    def getHubStatus: ZIO[Any, Nothing, zio.aws.sagemaker.model.HubStatus] =
      ZIO.succeed(hubStatus)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HubInfo
  ) extends zio.aws.sagemaker.model.HubInfo.ReadOnly {
    override val hubName: HubName =
      zio.aws.sagemaker.model.primitives.HubName(impl.hubName())
    override val hubArn: HubArn =
      zio.aws.sagemaker.model.primitives.HubArn(impl.hubArn())
    override val hubDisplayName: Optional[HubDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubDisplayName())
        .map(value => zio.aws.sagemaker.model.primitives.HubDisplayName(value))
    override val hubDescription: Optional[HubDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubDescription())
        .map(value => zio.aws.sagemaker.model.primitives.HubDescription(value))
    override val hubSearchKeywords: Optional[List[HubSearchKeyword]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubSearchKeywords())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.HubSearchKeyword(item)
          }.toList
        )
    override val hubStatus: zio.aws.sagemaker.model.HubStatus =
      zio.aws.sagemaker.model.HubStatus.wrap(impl.hubStatus())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val lastModifiedTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.lastModifiedTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HubInfo
  ): zio.aws.sagemaker.model.HubInfo.ReadOnly = new Wrapper(impl)
}
