package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.SecurityGroupId
import scala.jdk.CollectionConverters.*
final case class DomainSettingsForUpdate(
    rStudioServerProDomainSettingsForUpdate: Optional[
      zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate
    ] = Optional.Absent,
    executionRoleIdentityConfig: Optional[
      zio.aws.sagemaker.model.ExecutionRoleIdentityConfig
    ] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DomainSettingsForUpdate = {
    import DomainSettingsForUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DomainSettingsForUpdate
      .builder()
      .optionallyWith(
        rStudioServerProDomainSettingsForUpdate.map(value =>
          value.buildAwsValue()
        )
      )(_.rStudioServerProDomainSettingsForUpdate)
      .optionallyWith(executionRoleIdentityConfig.map(value => value.unwrap))(
        _.executionRoleIdentityConfig
      )
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DomainSettingsForUpdate.ReadOnly =
    zio.aws.sagemaker.model.DomainSettingsForUpdate.wrap(buildAwsValue())
}
object DomainSettingsForUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DomainSettingsForUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DomainSettingsForUpdate =
      zio.aws.sagemaker.model.DomainSettingsForUpdate(
        rStudioServerProDomainSettingsForUpdate.map(value => value.asEditable),
        executionRoleIdentityConfig.map(value => value),
        securityGroupIds.map(value => value)
      )
    def rStudioServerProDomainSettingsForUpdate: Optional[
      zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate.ReadOnly
    ]
    def executionRoleIdentityConfig
        : Optional[zio.aws.sagemaker.model.ExecutionRoleIdentityConfig]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def getRStudioServerProDomainSettingsForUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "rStudioServerProDomainSettingsForUpdate",
      rStudioServerProDomainSettingsForUpdate
    )
    def getExecutionRoleIdentityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ExecutionRoleIdentityConfig
    ] = AwsError.unwrapOptionField(
      "executionRoleIdentityConfig",
      executionRoleIdentityConfig
    )
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DomainSettingsForUpdate
  ) extends zio.aws.sagemaker.model.DomainSettingsForUpdate.ReadOnly {
    override val rStudioServerProDomainSettingsForUpdate: Optional[
      zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rStudioServerProDomainSettingsForUpdate())
      .map(value =>
        zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate
          .wrap(value)
      )
    override val executionRoleIdentityConfig
        : Optional[zio.aws.sagemaker.model.ExecutionRoleIdentityConfig] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionRoleIdentityConfig())
        .map(value =>
          zio.aws.sagemaker.model.ExecutionRoleIdentityConfig.wrap(value)
        )
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.SecurityGroupId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DomainSettingsForUpdate
  ): zio.aws.sagemaker.model.DomainSettingsForUpdate.ReadOnly = new Wrapper(
    impl
  )
}
