package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  AutoMLJobName,
  Timestamp,
  AutoMLFailureReason,
  AutoMLJobArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeAutoMlJobV2Response(
    autoMLJobName: AutoMLJobName,
    autoMLJobArn: AutoMLJobArn,
    autoMLJobInputDataConfig: Iterable[
      zio.aws.sagemaker.model.AutoMLJobChannel
    ],
    outputDataConfig: zio.aws.sagemaker.model.AutoMLOutputDataConfig,
    roleArn: RoleArn,
    autoMLJobObjective: Optional[zio.aws.sagemaker.model.AutoMLJobObjective] =
      Optional.Absent,
    autoMLProblemTypeConfig: Optional[
      zio.aws.sagemaker.model.AutoMLProblemTypeConfig
    ] = Optional.Absent,
    creationTime: Timestamp,
    endTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Timestamp,
    failureReason: Optional[AutoMLFailureReason] = Optional.Absent,
    partialFailureReasons: Optional[
      Iterable[zio.aws.sagemaker.model.AutoMLPartialFailureReason]
    ] = Optional.Absent,
    bestCandidate: Optional[zio.aws.sagemaker.model.AutoMLCandidate] =
      Optional.Absent,
    autoMLJobStatus: zio.aws.sagemaker.model.AutoMLJobStatus,
    autoMLJobSecondaryStatus: zio.aws.sagemaker.model.AutoMLJobSecondaryStatus,
    modelDeployConfig: Optional[zio.aws.sagemaker.model.ModelDeployConfig] =
      Optional.Absent,
    modelDeployResult: Optional[zio.aws.sagemaker.model.ModelDeployResult] =
      Optional.Absent,
    dataSplitConfig: Optional[zio.aws.sagemaker.model.AutoMLDataSplitConfig] =
      Optional.Absent,
    securityConfig: Optional[zio.aws.sagemaker.model.AutoMLSecurityConfig] =
      Optional.Absent,
    autoMLJobArtifacts: Optional[zio.aws.sagemaker.model.AutoMLJobArtifacts] =
      Optional.Absent,
    resolvedAttributes: Optional[
      zio.aws.sagemaker.model.AutoMLResolvedAttributes
    ] = Optional.Absent,
    autoMLProblemTypeConfigName: Optional[
      zio.aws.sagemaker.model.AutoMLProblemTypeConfigName
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobV2Response = {
    import DescribeAutoMlJobV2Response.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobV2Response
      .builder()
      .autoMLJobName(AutoMLJobName.unwrap(autoMLJobName): java.lang.String)
      .autoMLJobArn(AutoMLJobArn.unwrap(autoMLJobArn): java.lang.String)
      .autoMLJobInputDataConfig(autoMLJobInputDataConfig.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(autoMLJobObjective.map(value => value.buildAwsValue()))(
        _.autoMLJobObjective
      )
      .optionallyWith(
        autoMLProblemTypeConfig.map(value => value.buildAwsValue())
      )(_.autoMLProblemTypeConfig)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .optionallyWith(
        failureReason.map(value =>
          AutoMLFailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        partialFailureReasons.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.partialFailureReasons)
      .optionallyWith(bestCandidate.map(value => value.buildAwsValue()))(
        _.bestCandidate
      )
      .autoMLJobStatus(autoMLJobStatus.unwrap)
      .autoMLJobSecondaryStatus(autoMLJobSecondaryStatus.unwrap)
      .optionallyWith(modelDeployConfig.map(value => value.buildAwsValue()))(
        _.modelDeployConfig
      )
      .optionallyWith(modelDeployResult.map(value => value.buildAwsValue()))(
        _.modelDeployResult
      )
      .optionallyWith(dataSplitConfig.map(value => value.buildAwsValue()))(
        _.dataSplitConfig
      )
      .optionallyWith(securityConfig.map(value => value.buildAwsValue()))(
        _.securityConfig
      )
      .optionallyWith(autoMLJobArtifacts.map(value => value.buildAwsValue()))(
        _.autoMLJobArtifacts
      )
      .optionallyWith(resolvedAttributes.map(value => value.buildAwsValue()))(
        _.resolvedAttributes
      )
      .optionallyWith(autoMLProblemTypeConfigName.map(value => value.unwrap))(
        _.autoMLProblemTypeConfigName
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeAutoMlJobV2Response.ReadOnly =
    zio.aws.sagemaker.model.DescribeAutoMlJobV2Response.wrap(buildAwsValue())
}
object DescribeAutoMlJobV2Response {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobV2Response
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeAutoMlJobV2Response =
      zio.aws.sagemaker.model.DescribeAutoMlJobV2Response(
        autoMLJobName,
        autoMLJobArn,
        autoMLJobInputDataConfig.map { item =>
          item.asEditable
        },
        outputDataConfig.asEditable,
        roleArn,
        autoMLJobObjective.map(value => value.asEditable),
        autoMLProblemTypeConfig.map(value => value.asEditable),
        creationTime,
        endTime.map(value => value),
        lastModifiedTime,
        failureReason.map(value => value),
        partialFailureReasons.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        bestCandidate.map(value => value.asEditable),
        autoMLJobStatus,
        autoMLJobSecondaryStatus,
        modelDeployConfig.map(value => value.asEditable),
        modelDeployResult.map(value => value.asEditable),
        dataSplitConfig.map(value => value.asEditable),
        securityConfig.map(value => value.asEditable),
        autoMLJobArtifacts.map(value => value.asEditable),
        resolvedAttributes.map(value => value.asEditable),
        autoMLProblemTypeConfigName.map(value => value)
      )
    def autoMLJobName: AutoMLJobName
    def autoMLJobArn: AutoMLJobArn
    def autoMLJobInputDataConfig
        : List[zio.aws.sagemaker.model.AutoMLJobChannel.ReadOnly]
    def outputDataConfig
        : zio.aws.sagemaker.model.AutoMLOutputDataConfig.ReadOnly
    def roleArn: RoleArn
    def autoMLJobObjective
        : Optional[zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly]
    def autoMLProblemTypeConfig
        : Optional[zio.aws.sagemaker.model.AutoMLProblemTypeConfig.ReadOnly]
    def creationTime: Timestamp
    def endTime: Optional[Timestamp]
    def lastModifiedTime: Timestamp
    def failureReason: Optional[AutoMLFailureReason]
    def partialFailureReasons: Optional[
      List[zio.aws.sagemaker.model.AutoMLPartialFailureReason.ReadOnly]
    ]
    def bestCandidate
        : Optional[zio.aws.sagemaker.model.AutoMLCandidate.ReadOnly]
    def autoMLJobStatus: zio.aws.sagemaker.model.AutoMLJobStatus
    def autoMLJobSecondaryStatus
        : zio.aws.sagemaker.model.AutoMLJobSecondaryStatus
    def modelDeployConfig
        : Optional[zio.aws.sagemaker.model.ModelDeployConfig.ReadOnly]
    def modelDeployResult
        : Optional[zio.aws.sagemaker.model.ModelDeployResult.ReadOnly]
    def dataSplitConfig
        : Optional[zio.aws.sagemaker.model.AutoMLDataSplitConfig.ReadOnly]
    def securityConfig
        : Optional[zio.aws.sagemaker.model.AutoMLSecurityConfig.ReadOnly]
    def autoMLJobArtifacts
        : Optional[zio.aws.sagemaker.model.AutoMLJobArtifacts.ReadOnly]
    def resolvedAttributes
        : Optional[zio.aws.sagemaker.model.AutoMLResolvedAttributes.ReadOnly]
    def autoMLProblemTypeConfigName
        : Optional[zio.aws.sagemaker.model.AutoMLProblemTypeConfigName]
    def getAutoMLJobName: ZIO[Any, Nothing, AutoMLJobName] =
      ZIO.succeed(autoMLJobName)
    def getAutoMLJobArn: ZIO[Any, Nothing, AutoMLJobArn] =
      ZIO.succeed(autoMLJobArn)
    def getAutoMLJobInputDataConfig: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.AutoMLJobChannel.ReadOnly
    ]] = ZIO.succeed(autoMLJobInputDataConfig)
    def getOutputDataConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.AutoMLOutputDataConfig.ReadOnly
    ] = ZIO.succeed(outputDataConfig)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getAutoMLJobObjective: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly
    ] = AwsError.unwrapOptionField("autoMLJobObjective", autoMLJobObjective)
    def getAutoMLProblemTypeConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLProblemTypeConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoMLProblemTypeConfig",
      autoMLProblemTypeConfig
    )
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getFailureReason: ZIO[Any, AwsError, AutoMLFailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getPartialFailureReasons: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.AutoMLPartialFailureReason.ReadOnly
    ]] =
      AwsError.unwrapOptionField("partialFailureReasons", partialFailureReasons)
    def getBestCandidate
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AutoMLCandidate.ReadOnly] =
      AwsError.unwrapOptionField("bestCandidate", bestCandidate)
    def getAutoMLJobStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.AutoMLJobStatus] =
      ZIO.succeed(autoMLJobStatus)
    def getAutoMLJobSecondaryStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.AutoMLJobSecondaryStatus] =
      ZIO.succeed(autoMLJobSecondaryStatus)
    def getModelDeployConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelDeployConfig.ReadOnly
    ] = AwsError.unwrapOptionField("modelDeployConfig", modelDeployConfig)
    def getModelDeployResult: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelDeployResult.ReadOnly
    ] = AwsError.unwrapOptionField("modelDeployResult", modelDeployResult)
    def getDataSplitConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLDataSplitConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dataSplitConfig", dataSplitConfig)
    def getSecurityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLSecurityConfig.ReadOnly
    ] = AwsError.unwrapOptionField("securityConfig", securityConfig)
    def getAutoMLJobArtifacts: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLJobArtifacts.ReadOnly
    ] = AwsError.unwrapOptionField("autoMLJobArtifacts", autoMLJobArtifacts)
    def getResolvedAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLResolvedAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("resolvedAttributes", resolvedAttributes)
    def getAutoMLProblemTypeConfigName: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLProblemTypeConfigName
    ] = AwsError.unwrapOptionField(
      "autoMLProblemTypeConfigName",
      autoMLProblemTypeConfigName
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobV2Response
  ) extends zio.aws.sagemaker.model.DescribeAutoMlJobV2Response.ReadOnly {
    override val autoMLJobName: AutoMLJobName =
      zio.aws.sagemaker.model.primitives.AutoMLJobName(impl.autoMLJobName())
    override val autoMLJobArn: AutoMLJobArn =
      zio.aws.sagemaker.model.primitives.AutoMLJobArn(impl.autoMLJobArn())
    override val autoMLJobInputDataConfig
        : List[zio.aws.sagemaker.model.AutoMLJobChannel.ReadOnly] = impl
      .autoMLJobInputDataConfig()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.AutoMLJobChannel.wrap(item)
      }
      .toList
    override val outputDataConfig
        : zio.aws.sagemaker.model.AutoMLOutputDataConfig.ReadOnly =
      zio.aws.sagemaker.model.AutoMLOutputDataConfig
        .wrap(impl.outputDataConfig())
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val autoMLJobObjective
        : Optional[zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMLJobObjective())
        .map(value => zio.aws.sagemaker.model.AutoMLJobObjective.wrap(value))
    override val autoMLProblemTypeConfig
        : Optional[zio.aws.sagemaker.model.AutoMLProblemTypeConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMLProblemTypeConfig())
        .map(value =>
          zio.aws.sagemaker.model.AutoMLProblemTypeConfig.wrap(value)
        )
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.lastModifiedTime())
    override val failureReason: Optional[AutoMLFailureReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReason())
        .map(value =>
          zio.aws.sagemaker.model.primitives.AutoMLFailureReason(value)
        )
    override val partialFailureReasons: Optional[
      List[zio.aws.sagemaker.model.AutoMLPartialFailureReason.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.partialFailureReasons())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.AutoMLPartialFailureReason.wrap(item)
        }.toList
      )
    override val bestCandidate
        : Optional[zio.aws.sagemaker.model.AutoMLCandidate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bestCandidate())
        .map(value => zio.aws.sagemaker.model.AutoMLCandidate.wrap(value))
    override val autoMLJobStatus: zio.aws.sagemaker.model.AutoMLJobStatus =
      zio.aws.sagemaker.model.AutoMLJobStatus.wrap(impl.autoMLJobStatus())
    override val autoMLJobSecondaryStatus
        : zio.aws.sagemaker.model.AutoMLJobSecondaryStatus =
      zio.aws.sagemaker.model.AutoMLJobSecondaryStatus
        .wrap(impl.autoMLJobSecondaryStatus())
    override val modelDeployConfig
        : Optional[zio.aws.sagemaker.model.ModelDeployConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelDeployConfig())
        .map(value => zio.aws.sagemaker.model.ModelDeployConfig.wrap(value))
    override val modelDeployResult
        : Optional[zio.aws.sagemaker.model.ModelDeployResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelDeployResult())
        .map(value => zio.aws.sagemaker.model.ModelDeployResult.wrap(value))
    override val dataSplitConfig
        : Optional[zio.aws.sagemaker.model.AutoMLDataSplitConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSplitConfig())
        .map(value => zio.aws.sagemaker.model.AutoMLDataSplitConfig.wrap(value))
    override val securityConfig
        : Optional[zio.aws.sagemaker.model.AutoMLSecurityConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityConfig())
        .map(value => zio.aws.sagemaker.model.AutoMLSecurityConfig.wrap(value))
    override val autoMLJobArtifacts
        : Optional[zio.aws.sagemaker.model.AutoMLJobArtifacts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMLJobArtifacts())
        .map(value => zio.aws.sagemaker.model.AutoMLJobArtifacts.wrap(value))
    override val resolvedAttributes
        : Optional[zio.aws.sagemaker.model.AutoMLResolvedAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resolvedAttributes())
        .map(value =>
          zio.aws.sagemaker.model.AutoMLResolvedAttributes.wrap(value)
        )
    override val autoMLProblemTypeConfigName
        : Optional[zio.aws.sagemaker.model.AutoMLProblemTypeConfigName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMLProblemTypeConfigName())
        .map(value =>
          zio.aws.sagemaker.model.AutoMLProblemTypeConfigName.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobV2Response
  ): zio.aws.sagemaker.model.DescribeAutoMlJobV2Response.ReadOnly = new Wrapper(
    impl
  )
}
