package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.MonitoringJobDefinitionName
import scala.jdk.CollectionConverters.*
final case class DeleteModelBiasJobDefinitionRequest(
    jobDefinitionName: MonitoringJobDefinitionName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteModelBiasJobDefinitionRequest = {
    import DeleteModelBiasJobDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteModelBiasJobDefinitionRequest
      .builder()
      .jobDefinitionName(
        MonitoringJobDefinitionName.unwrap(jobDefinitionName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DeleteModelBiasJobDefinitionRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteModelBiasJobDefinitionRequest
      .wrap(buildAwsValue())
}
object DeleteModelBiasJobDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteModelBiasJobDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DeleteModelBiasJobDefinitionRequest =
      zio.aws.sagemaker.model
        .DeleteModelBiasJobDefinitionRequest(jobDefinitionName)
    def jobDefinitionName: MonitoringJobDefinitionName
    def getJobDefinitionName: ZIO[Any, Nothing, MonitoringJobDefinitionName] =
      ZIO.succeed(jobDefinitionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteModelBiasJobDefinitionRequest
  ) extends zio.aws.sagemaker.model.DeleteModelBiasJobDefinitionRequest.ReadOnly {
    override val jobDefinitionName: MonitoringJobDefinitionName =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionName(impl.jobDefinitionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteModelBiasJobDefinitionRequest
  ): zio.aws.sagemaker.model.DeleteModelBiasJobDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
