package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  S3Uri,
  RoleArn,
  LabelAttributeName,
  LabelingJobName
}
import scala.jdk.CollectionConverters.*
final case class CreateLabelingJobRequest(
    labelingJobName: LabelingJobName,
    labelAttributeName: LabelAttributeName,
    inputConfig: zio.aws.sagemaker.model.LabelingJobInputConfig,
    outputConfig: zio.aws.sagemaker.model.LabelingJobOutputConfig,
    roleArn: RoleArn,
    labelCategoryConfigS3Uri: Optional[S3Uri] = Optional.Absent,
    stoppingConditions: Optional[
      zio.aws.sagemaker.model.LabelingJobStoppingConditions
    ] = Optional.Absent,
    labelingJobAlgorithmsConfig: Optional[
      zio.aws.sagemaker.model.LabelingJobAlgorithmsConfig
    ] = Optional.Absent,
    humanTaskConfig: zio.aws.sagemaker.model.HumanTaskConfig,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobRequest = {
    import CreateLabelingJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobRequest
      .builder()
      .labelingJobName(
        LabelingJobName.unwrap(labelingJobName): java.lang.String
      )
      .labelAttributeName(
        LabelAttributeName.unwrap(labelAttributeName): java.lang.String
      )
      .inputConfig(inputConfig.buildAwsValue())
      .outputConfig(outputConfig.buildAwsValue())
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        labelCategoryConfigS3Uri.map(value =>
          S3Uri.unwrap(value): java.lang.String
        )
      )(_.labelCategoryConfigS3Uri)
      .optionallyWith(stoppingConditions.map(value => value.buildAwsValue()))(
        _.stoppingConditions
      )
      .optionallyWith(
        labelingJobAlgorithmsConfig.map(value => value.buildAwsValue())
      )(_.labelingJobAlgorithmsConfig)
      .humanTaskConfig(humanTaskConfig.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateLabelingJobRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateLabelingJobRequest.wrap(buildAwsValue())
}
object CreateLabelingJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateLabelingJobRequest =
      zio.aws.sagemaker.model.CreateLabelingJobRequest(
        labelingJobName,
        labelAttributeName,
        inputConfig.asEditable,
        outputConfig.asEditable,
        roleArn,
        labelCategoryConfigS3Uri.map(value => value),
        stoppingConditions.map(value => value.asEditable),
        labelingJobAlgorithmsConfig.map(value => value.asEditable),
        humanTaskConfig.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def labelingJobName: LabelingJobName
    def labelAttributeName: LabelAttributeName
    def inputConfig: zio.aws.sagemaker.model.LabelingJobInputConfig.ReadOnly
    def outputConfig: zio.aws.sagemaker.model.LabelingJobOutputConfig.ReadOnly
    def roleArn: RoleArn
    def labelCategoryConfigS3Uri: Optional[S3Uri]
    def stoppingConditions: Optional[
      zio.aws.sagemaker.model.LabelingJobStoppingConditions.ReadOnly
    ]
    def labelingJobAlgorithmsConfig
        : Optional[zio.aws.sagemaker.model.LabelingJobAlgorithmsConfig.ReadOnly]
    def humanTaskConfig: zio.aws.sagemaker.model.HumanTaskConfig.ReadOnly
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getLabelingJobName: ZIO[Any, Nothing, LabelingJobName] =
      ZIO.succeed(labelingJobName)
    def getLabelAttributeName: ZIO[Any, Nothing, LabelAttributeName] =
      ZIO.succeed(labelAttributeName)
    def getInputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.LabelingJobInputConfig.ReadOnly
    ] = ZIO.succeed(inputConfig)
    def getOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.LabelingJobOutputConfig.ReadOnly
    ] = ZIO.succeed(outputConfig)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getLabelCategoryConfigS3Uri: ZIO[Any, AwsError, S3Uri] = AwsError
      .unwrapOptionField("labelCategoryConfigS3Uri", labelCategoryConfigS3Uri)
    def getStoppingConditions: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.LabelingJobStoppingConditions.ReadOnly
    ] = AwsError.unwrapOptionField("stoppingConditions", stoppingConditions)
    def getLabelingJobAlgorithmsConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.LabelingJobAlgorithmsConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "labelingJobAlgorithmsConfig",
      labelingJobAlgorithmsConfig
    )
    def getHumanTaskConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.HumanTaskConfig.ReadOnly] =
      ZIO.succeed(humanTaskConfig)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobRequest
  ) extends zio.aws.sagemaker.model.CreateLabelingJobRequest.ReadOnly {
    override val labelingJobName: LabelingJobName =
      zio.aws.sagemaker.model.primitives.LabelingJobName(impl.labelingJobName())
    override val labelAttributeName: LabelAttributeName =
      zio.aws.sagemaker.model.primitives
        .LabelAttributeName(impl.labelAttributeName())
    override val inputConfig
        : zio.aws.sagemaker.model.LabelingJobInputConfig.ReadOnly =
      zio.aws.sagemaker.model.LabelingJobInputConfig.wrap(impl.inputConfig())
    override val outputConfig
        : zio.aws.sagemaker.model.LabelingJobOutputConfig.ReadOnly =
      zio.aws.sagemaker.model.LabelingJobOutputConfig.wrap(impl.outputConfig())
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val labelCategoryConfigS3Uri: Optional[S3Uri] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelCategoryConfigS3Uri())
        .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
    override val stoppingConditions: Optional[
      zio.aws.sagemaker.model.LabelingJobStoppingConditions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stoppingConditions())
      .map(value =>
        zio.aws.sagemaker.model.LabelingJobStoppingConditions.wrap(value)
      )
    override val labelingJobAlgorithmsConfig: Optional[
      zio.aws.sagemaker.model.LabelingJobAlgorithmsConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.labelingJobAlgorithmsConfig())
      .map(value =>
        zio.aws.sagemaker.model.LabelingJobAlgorithmsConfig.wrap(value)
      )
    override val humanTaskConfig
        : zio.aws.sagemaker.model.HumanTaskConfig.ReadOnly =
      zio.aws.sagemaker.model.HumanTaskConfig.wrap(impl.humanTaskConfig())
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobRequest
  ): zio.aws.sagemaker.model.CreateLabelingJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
