package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  KmsKeyId,
  VpcId,
  SubnetId,
  DomainName
}
import scala.jdk.CollectionConverters.*
final case class CreateDomainRequest(
    domainName: DomainName,
    authMode: zio.aws.sagemaker.model.AuthMode,
    defaultUserSettings: zio.aws.sagemaker.model.UserSettings,
    subnetIds: Iterable[SubnetId],
    vpcId: VpcId,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent,
    appNetworkAccessType: Optional[
      zio.aws.sagemaker.model.AppNetworkAccessType
    ] = Optional.Absent,
    homeEfsFileSystemKmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    appSecurityGroupManagement: Optional[
      zio.aws.sagemaker.model.AppSecurityGroupManagement
    ] = Optional.Absent,
    domainSettings: Optional[zio.aws.sagemaker.model.DomainSettings] =
      Optional.Absent,
    defaultSpaceSettings: Optional[
      zio.aws.sagemaker.model.DefaultSpaceSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateDomainRequest = {
    import CreateDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateDomainRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .authMode(authMode.unwrap)
      .defaultUserSettings(defaultUserSettings.buildAwsValue())
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(appNetworkAccessType.map(value => value.unwrap))(
        _.appNetworkAccessType
      )
      .optionallyWith(
        homeEfsFileSystemKmsKeyId.map(value =>
          KmsKeyId.unwrap(value): java.lang.String
        )
      )(_.homeEfsFileSystemKmsKeyId)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(appSecurityGroupManagement.map(value => value.unwrap))(
        _.appSecurityGroupManagement
      )
      .optionallyWith(domainSettings.map(value => value.buildAwsValue()))(
        _.domainSettings
      )
      .optionallyWith(defaultSpaceSettings.map(value => value.buildAwsValue()))(
        _.defaultSpaceSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateDomainRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateDomainRequest.wrap(buildAwsValue())
}
object CreateDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateDomainRequest =
      zio.aws.sagemaker.model.CreateDomainRequest(
        domainName,
        authMode,
        defaultUserSettings.asEditable,
        subnetIds,
        vpcId,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        appNetworkAccessType.map(value => value),
        homeEfsFileSystemKmsKeyId.map(value => value),
        kmsKeyId.map(value => value),
        appSecurityGroupManagement.map(value => value),
        domainSettings.map(value => value.asEditable),
        defaultSpaceSettings.map(value => value.asEditable)
      )
    def domainName: DomainName
    def authMode: zio.aws.sagemaker.model.AuthMode
    def defaultUserSettings: zio.aws.sagemaker.model.UserSettings.ReadOnly
    def subnetIds: List[SubnetId]
    def vpcId: VpcId
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def appNetworkAccessType
        : Optional[zio.aws.sagemaker.model.AppNetworkAccessType]
    def homeEfsFileSystemKmsKeyId: Optional[KmsKeyId]
    def kmsKeyId: Optional[KmsKeyId]
    def appSecurityGroupManagement
        : Optional[zio.aws.sagemaker.model.AppSecurityGroupManagement]
    def domainSettings
        : Optional[zio.aws.sagemaker.model.DomainSettings.ReadOnly]
    def defaultSpaceSettings
        : Optional[zio.aws.sagemaker.model.DefaultSpaceSettings.ReadOnly]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getAuthMode: ZIO[Any, Nothing, zio.aws.sagemaker.model.AuthMode] =
      ZIO.succeed(authMode)
    def getDefaultUserSettings
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.UserSettings.ReadOnly] =
      ZIO.succeed(defaultUserSettings)
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAppNetworkAccessType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AppNetworkAccessType] =
      AwsError.unwrapOptionField("appNetworkAccessType", appNetworkAccessType)
    def getHomeEfsFileSystemKmsKeyId: ZIO[Any, AwsError, KmsKeyId] = AwsError
      .unwrapOptionField("homeEfsFileSystemKmsKeyId", homeEfsFileSystemKmsKeyId)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getAppSecurityGroupManagement: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AppSecurityGroupManagement
    ] = AwsError.unwrapOptionField(
      "appSecurityGroupManagement",
      appSecurityGroupManagement
    )
    def getDomainSettings
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.DomainSettings.ReadOnly] =
      AwsError.unwrapOptionField("domainSettings", domainSettings)
    def getDefaultSpaceSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DefaultSpaceSettings.ReadOnly
    ] = AwsError.unwrapOptionField("defaultSpaceSettings", defaultSpaceSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateDomainRequest
  ) extends zio.aws.sagemaker.model.CreateDomainRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.sagemaker.model.primitives.DomainName(impl.domainName())
    override val authMode: zio.aws.sagemaker.model.AuthMode =
      zio.aws.sagemaker.model.AuthMode.wrap(impl.authMode())
    override val defaultUserSettings
        : zio.aws.sagemaker.model.UserSettings.ReadOnly =
      zio.aws.sagemaker.model.UserSettings.wrap(impl.defaultUserSettings())
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.primitives.SubnetId(item)
      }
      .toList
    override val vpcId: VpcId =
      zio.aws.sagemaker.model.primitives.VpcId(impl.vpcId())
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val appNetworkAccessType
        : Optional[zio.aws.sagemaker.model.AppNetworkAccessType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appNetworkAccessType())
        .map(value => zio.aws.sagemaker.model.AppNetworkAccessType.wrap(value))
    override val homeEfsFileSystemKmsKeyId: Optional[KmsKeyId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.homeEfsFileSystemKmsKeyId())
        .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val appSecurityGroupManagement
        : Optional[zio.aws.sagemaker.model.AppSecurityGroupManagement] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appSecurityGroupManagement())
        .map(value =>
          zio.aws.sagemaker.model.AppSecurityGroupManagement.wrap(value)
        )
    override val domainSettings
        : Optional[zio.aws.sagemaker.model.DomainSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainSettings())
        .map(value => zio.aws.sagemaker.model.DomainSettings.wrap(value))
    override val defaultSpaceSettings
        : Optional[zio.aws.sagemaker.model.DefaultSpaceSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultSpaceSettings())
        .map(value => zio.aws.sagemaker.model.DefaultSpaceSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateDomainRequest
  ): zio.aws.sagemaker.model.CreateDomainRequest.ReadOnly = new Wrapper(impl)
}
