package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait AutoMLProblemTypeConfigName {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfigName
}
object AutoMLProblemTypeConfigName {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfigName
  ): zio.aws.sagemaker.model.AutoMLProblemTypeConfigName = value match {
    case software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfigName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfigName.IMAGE_CLASSIFICATION =>
      val r = ImageClassification
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfigName.TEXT_CLASSIFICATION =>
      val r = TextClassification
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfigName.TABULAR =>
      val r = Tabular
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfigName.TIME_SERIES_FORECASTING =>
      val r = TimeSeriesForecasting
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AutoMLProblemTypeConfigName {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfigName =
      software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfigName.UNKNOWN_TO_SDK_VERSION
  }
  case object ImageClassification
      extends zio.aws.sagemaker.model.AutoMLProblemTypeConfigName {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfigName =
      software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfigName.IMAGE_CLASSIFICATION
  }
  case object TextClassification
      extends zio.aws.sagemaker.model.AutoMLProblemTypeConfigName {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfigName =
      software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfigName.TEXT_CLASSIFICATION
  }
  case object Tabular
      extends zio.aws.sagemaker.model.AutoMLProblemTypeConfigName {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfigName =
      software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfigName.TABULAR
  }
  case object TimeSeriesForecasting
      extends zio.aws.sagemaker.model.AutoMLProblemTypeConfigName {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfigName =
      software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfigName.TIME_SERIES_FORECASTING
  }
}
