package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EndpointArn
import scala.jdk.CollectionConverters.*
final case class UpdateEndpointWeightsAndCapacitiesResponse(
    endpointArn: EndpointArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse = {
    import UpdateEndpointWeightsAndCapacitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse
      .builder()
      .endpointArn(EndpointArn.unwrap(endpointArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse
      .wrap(buildAwsValue())
}
object UpdateEndpointWeightsAndCapacitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse =
      zio.aws.sagemaker.model
        .UpdateEndpointWeightsAndCapacitiesResponse(endpointArn)
    def endpointArn: EndpointArn
    def getEndpointArn: ZIO[Any, Nothing, EndpointArn] =
      ZIO.succeed(endpointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse
  ) extends zio.aws.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse.ReadOnly {
    override val endpointArn: EndpointArn =
      zio.aws.sagemaker.model.primitives.EndpointArn(impl.endpointArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse
  ): zio.aws.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse.ReadOnly =
    new Wrapper(impl)
}
