package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{TemplateContentSha256, TemplateUrl}
import scala.jdk.CollectionConverters.*
final case class UiTemplateInfo(
    url: Optional[TemplateUrl] = Optional.Absent,
    contentSha256: Optional[TemplateContentSha256] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UiTemplateInfo = {
    import UiTemplateInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UiTemplateInfo
      .builder()
      .optionallyWith(
        url.map(value => TemplateUrl.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(
        contentSha256.map(value =>
          TemplateContentSha256.unwrap(value): java.lang.String
        )
      )(_.contentSha256)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UiTemplateInfo.ReadOnly =
    zio.aws.sagemaker.model.UiTemplateInfo.wrap(buildAwsValue())
}
object UiTemplateInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UiTemplateInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UiTemplateInfo =
      zio.aws.sagemaker.model.UiTemplateInfo(
        url.map(value => value),
        contentSha256.map(value => value)
      )
    def url: Optional[TemplateUrl]
    def contentSha256: Optional[TemplateContentSha256]
    def getUrl: ZIO[Any, AwsError, TemplateUrl] =
      AwsError.unwrapOptionField("url", url)
    def getContentSha256: ZIO[Any, AwsError, TemplateContentSha256] =
      AwsError.unwrapOptionField("contentSha256", contentSha256)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UiTemplateInfo
  ) extends zio.aws.sagemaker.model.UiTemplateInfo.ReadOnly {
    override val url: Optional[TemplateUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.sagemaker.model.primitives.TemplateUrl(value))
    override val contentSha256: Optional[TemplateContentSha256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentSha256())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TemplateContentSha256(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UiTemplateInfo
  ): zio.aws.sagemaker.model.UiTemplateInfo.ReadOnly = new Wrapper(impl)
}
