package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.HyperParameterTuningJobArn
import scala.jdk.CollectionConverters.*
final case class TuningJobStepMetaData(
    arn: Optional[HyperParameterTuningJobArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TuningJobStepMetaData = {
    import TuningJobStepMetaData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TuningJobStepMetaData
      .builder()
      .optionallyWith(
        arn.map(value =>
          HyperParameterTuningJobArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TuningJobStepMetaData.ReadOnly =
    zio.aws.sagemaker.model.TuningJobStepMetaData.wrap(buildAwsValue())
}
object TuningJobStepMetaData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TuningJobStepMetaData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TuningJobStepMetaData =
      zio.aws.sagemaker.model.TuningJobStepMetaData(arn.map(value => value))
    def arn: Optional[HyperParameterTuningJobArn]
    def getArn: ZIO[Any, AwsError, HyperParameterTuningJobArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TuningJobStepMetaData
  ) extends zio.aws.sagemaker.model.TuningJobStepMetaData.ReadOnly {
    override val arn: Optional[HyperParameterTuningJobArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.HyperParameterTuningJobArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TuningJobStepMetaData
  ): zio.aws.sagemaker.model.TuningJobStepMetaData.ReadOnly = new Wrapper(impl)
}
