package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.InferenceExperimentArn
import scala.jdk.CollectionConverters.*
final case class StartInferenceExperimentResponse(
    inferenceExperimentArn: InferenceExperimentArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StartInferenceExperimentResponse = {
    import StartInferenceExperimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StartInferenceExperimentResponse
      .builder()
      .inferenceExperimentArn(
        InferenceExperimentArn.unwrap(inferenceExperimentArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.StartInferenceExperimentResponse.ReadOnly =
    zio.aws.sagemaker.model.StartInferenceExperimentResponse
      .wrap(buildAwsValue())
}
object StartInferenceExperimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StartInferenceExperimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.StartInferenceExperimentResponse =
      zio.aws.sagemaker.model
        .StartInferenceExperimentResponse(inferenceExperimentArn)
    def inferenceExperimentArn: InferenceExperimentArn
    def getInferenceExperimentArn: ZIO[Any, Nothing, InferenceExperimentArn] =
      ZIO.succeed(inferenceExperimentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StartInferenceExperimentResponse
  ) extends zio.aws.sagemaker.model.StartInferenceExperimentResponse.ReadOnly {
    override val inferenceExperimentArn: InferenceExperimentArn =
      zio.aws.sagemaker.model.primitives
        .InferenceExperimentArn(impl.inferenceExperimentArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StartInferenceExperimentResponse
  ): zio.aws.sagemaker.model.StartInferenceExperimentResponse.ReadOnly =
    new Wrapper(impl)
}
