package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RSessionAppSettings(
    defaultResourceSpec: Optional[zio.aws.sagemaker.model.ResourceSpec] =
      Optional.Absent,
    customImages: Optional[Iterable[zio.aws.sagemaker.model.CustomImage]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RSessionAppSettings = {
    import RSessionAppSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RSessionAppSettings
      .builder()
      .optionallyWith(defaultResourceSpec.map(value => value.buildAwsValue()))(
        _.defaultResourceSpec
      )
      .optionallyWith(
        customImages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customImages)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.RSessionAppSettings.ReadOnly =
    zio.aws.sagemaker.model.RSessionAppSettings.wrap(buildAwsValue())
}
object RSessionAppSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RSessionAppSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RSessionAppSettings =
      zio.aws.sagemaker.model.RSessionAppSettings(
        defaultResourceSpec.map(value => value.asEditable),
        customImages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def defaultResourceSpec
        : Optional[zio.aws.sagemaker.model.ResourceSpec.ReadOnly]
    def customImages
        : Optional[List[zio.aws.sagemaker.model.CustomImage.ReadOnly]]
    def getDefaultResourceSpec
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      AwsError.unwrapOptionField("defaultResourceSpec", defaultResourceSpec)
    def getCustomImages: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.CustomImage.ReadOnly
    ]] = AwsError.unwrapOptionField("customImages", customImages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RSessionAppSettings
  ) extends zio.aws.sagemaker.model.RSessionAppSettings.ReadOnly {
    override val defaultResourceSpec
        : Optional[zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultResourceSpec())
        .map(value => zio.aws.sagemaker.model.ResourceSpec.wrap(value))
    override val customImages
        : Optional[List[zio.aws.sagemaker.model.CustomImage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customImages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.CustomImage.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RSessionAppSettings
  ): zio.aws.sagemaker.model.RSessionAppSettings.ReadOnly = new Wrapper(impl)
}
