package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait MonitoringProblemType {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.MonitoringProblemType
}
object MonitoringProblemType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.MonitoringProblemType
  ): zio.aws.sagemaker.model.MonitoringProblemType = value match {
    case software.amazon.awssdk.services.sagemaker.model.MonitoringProblemType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.MonitoringProblemType.BINARY_CLASSIFICATION =>
      val r = BinaryClassification
      r
    case software.amazon.awssdk.services.sagemaker.model.MonitoringProblemType.MULTICLASS_CLASSIFICATION =>
      val r = MulticlassClassification
      r
    case software.amazon.awssdk.services.sagemaker.model.MonitoringProblemType.REGRESSION =>
      val r = Regression
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.MonitoringProblemType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.MonitoringProblemType =
      software.amazon.awssdk.services.sagemaker.model.MonitoringProblemType.UNKNOWN_TO_SDK_VERSION
  }
  case object BinaryClassification
      extends zio.aws.sagemaker.model.MonitoringProblemType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.MonitoringProblemType =
      software.amazon.awssdk.services.sagemaker.model.MonitoringProblemType.BINARY_CLASSIFICATION
  }
  case object MulticlassClassification
      extends zio.aws.sagemaker.model.MonitoringProblemType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.MonitoringProblemType =
      software.amazon.awssdk.services.sagemaker.model.MonitoringProblemType.MULTICLASS_CLASSIFICATION
  }
  case object Regression extends zio.aws.sagemaker.model.MonitoringProblemType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.MonitoringProblemType =
      software.amazon.awssdk.services.sagemaker.model.MonitoringProblemType.REGRESSION
  }
}
