package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ModelPackageType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ModelPackageType
}
object ModelPackageType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ModelPackageType
  ): zio.aws.sagemaker.model.ModelPackageType = value match {
    case software.amazon.awssdk.services.sagemaker.model.ModelPackageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelPackageType.VERSIONED =>
      val r = Versioned
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelPackageType.UNVERSIONED =>
      val r = Unversioned
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelPackageType.BOTH =>
      val r = Both
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ModelPackageType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelPackageType =
      software.amazon.awssdk.services.sagemaker.model.ModelPackageType.UNKNOWN_TO_SDK_VERSION
  }
  case object Versioned extends zio.aws.sagemaker.model.ModelPackageType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelPackageType =
      software.amazon.awssdk.services.sagemaker.model.ModelPackageType.VERSIONED
  }
  case object Unversioned extends zio.aws.sagemaker.model.ModelPackageType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelPackageType =
      software.amazon.awssdk.services.sagemaker.model.ModelPackageType.UNVERSIONED
  }
  case object Both extends zio.aws.sagemaker.model.ModelPackageType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelPackageType =
      software.amazon.awssdk.services.sagemaker.model.ModelPackageType.BOTH
  }
}
