package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.KmsKeyId
import scala.jdk.CollectionConverters.*
final case class ModelCardSecurityConfig(
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelCardSecurityConfig = {
    import ModelCardSecurityConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelCardSecurityConfig
      .builder()
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelCardSecurityConfig.ReadOnly =
    zio.aws.sagemaker.model.ModelCardSecurityConfig.wrap(buildAwsValue())
}
object ModelCardSecurityConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelCardSecurityConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelCardSecurityConfig =
      zio.aws.sagemaker.model
        .ModelCardSecurityConfig(kmsKeyId.map(value => value))
    def kmsKeyId: Optional[KmsKeyId]
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelCardSecurityConfig
  ) extends zio.aws.sagemaker.model.ModelCardSecurityConfig.ReadOnly {
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelCardSecurityConfig
  ): zio.aws.sagemaker.model.ModelCardSecurityConfig.ReadOnly = new Wrapper(
    impl
  )
}
