package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  MonitoringScheduleName,
  Timestamp,
  MonitoringAlertName,
  MaxResults
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListMonitoringAlertHistoryRequest(
    monitoringScheduleName: Optional[MonitoringScheduleName] = Optional.Absent,
    monitoringAlertName: Optional[MonitoringAlertName] = Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.MonitoringAlertHistorySortKey] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    creationTimeBefore: Optional[Timestamp] = Optional.Absent,
    creationTimeAfter: Optional[Timestamp] = Optional.Absent,
    statusEquals: Optional[zio.aws.sagemaker.model.MonitoringAlertStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertHistoryRequest = {
    import ListMonitoringAlertHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertHistoryRequest
      .builder()
      .optionallyWith(
        monitoringScheduleName.map(value =>
          MonitoringScheduleName.unwrap(value): java.lang.String
        )
      )(_.monitoringScheduleName)
      .optionallyWith(
        monitoringAlertName.map(value =>
          MonitoringAlertName.unwrap(value): java.lang.String
        )
      )(_.monitoringAlertName)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListMonitoringAlertHistoryRequest.ReadOnly =
    zio.aws.sagemaker.model.ListMonitoringAlertHistoryRequest
      .wrap(buildAwsValue())
}
object ListMonitoringAlertHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListMonitoringAlertHistoryRequest =
      zio.aws.sagemaker.model.ListMonitoringAlertHistoryRequest(
        monitoringScheduleName.map(value => value),
        monitoringAlertName.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        creationTimeBefore.map(value => value),
        creationTimeAfter.map(value => value),
        statusEquals.map(value => value)
      )
    def monitoringScheduleName: Optional[MonitoringScheduleName]
    def monitoringAlertName: Optional[MonitoringAlertName]
    def sortBy: Optional[zio.aws.sagemaker.model.MonitoringAlertHistorySortKey]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def creationTimeBefore: Optional[Timestamp]
    def creationTimeAfter: Optional[Timestamp]
    def statusEquals: Optional[zio.aws.sagemaker.model.MonitoringAlertStatus]
    def getMonitoringScheduleName: ZIO[Any, AwsError, MonitoringScheduleName] =
      AwsError.unwrapOptionField(
        "monitoringScheduleName",
        monitoringScheduleName
      )
    def getMonitoringAlertName: ZIO[Any, AwsError, MonitoringAlertName] =
      AwsError.unwrapOptionField("monitoringAlertName", monitoringAlertName)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringAlertHistorySortKey
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MonitoringAlertStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertHistoryRequest
  ) extends zio.aws.sagemaker.model.ListMonitoringAlertHistoryRequest.ReadOnly {
    override val monitoringScheduleName: Optional[MonitoringScheduleName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringScheduleName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.MonitoringScheduleName(value)
        )
    override val monitoringAlertName: Optional[MonitoringAlertName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringAlertName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.MonitoringAlertName(value)
        )
    override val sortBy
        : Optional[zio.aws.sagemaker.model.MonitoringAlertHistorySortKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringAlertHistorySortKey.wrap(value)
        )
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val statusEquals
        : Optional[zio.aws.sagemaker.model.MonitoringAlertStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusEquals())
        .map(value => zio.aws.sagemaker.model.MonitoringAlertStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertHistoryRequest
  ): zio.aws.sagemaker.model.ListMonitoringAlertHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
