package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListModelCardsResponse(
    modelCardSummaries: Iterable[zio.aws.sagemaker.model.ModelCardSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListModelCardsResponse = {
    import ListModelCardsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListModelCardsResponse
      .builder()
      .modelCardSummaries(modelCardSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListModelCardsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListModelCardsResponse.wrap(buildAwsValue())
}
object ListModelCardsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListModelCardsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListModelCardsResponse =
      zio.aws.sagemaker.model.ListModelCardsResponse(
        modelCardSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def modelCardSummaries
        : List[zio.aws.sagemaker.model.ModelCardSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getModelCardSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.ModelCardSummary.ReadOnly
    ]] = ZIO.succeed(modelCardSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelCardsResponse
  ) extends zio.aws.sagemaker.model.ListModelCardsResponse.ReadOnly {
    override val modelCardSummaries
        : List[zio.aws.sagemaker.model.ModelCardSummary.ReadOnly] = impl
      .modelCardSummaries()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.ModelCardSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelCardsResponse
  ): zio.aws.sagemaker.model.ListModelCardsResponse.ReadOnly = new Wrapper(impl)
}
