package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListModelCardExportJobsResponse(
    modelCardExportJobSummaries: Iterable[
      zio.aws.sagemaker.model.ModelCardExportJobSummary
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListModelCardExportJobsResponse = {
    import ListModelCardExportJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListModelCardExportJobsResponse
      .builder()
      .modelCardExportJobSummaries(modelCardExportJobSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListModelCardExportJobsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListModelCardExportJobsResponse
      .wrap(buildAwsValue())
}
object ListModelCardExportJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListModelCardExportJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListModelCardExportJobsResponse =
      zio.aws.sagemaker.model.ListModelCardExportJobsResponse(
        modelCardExportJobSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def modelCardExportJobSummaries
        : List[zio.aws.sagemaker.model.ModelCardExportJobSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getModelCardExportJobSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.ModelCardExportJobSummary.ReadOnly
    ]] = ZIO.succeed(modelCardExportJobSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelCardExportJobsResponse
  ) extends zio.aws.sagemaker.model.ListModelCardExportJobsResponse.ReadOnly {
    override val modelCardExportJobSummaries
        : List[zio.aws.sagemaker.model.ModelCardExportJobSummary.ReadOnly] =
      impl
        .modelCardExportJobSummaries()
        .asScala
        .map { item =>
          zio.aws.sagemaker.model.ModelCardExportJobSummary.wrap(item)
        }
        .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelCardExportJobsResponse
  ): zio.aws.sagemaker.model.ListModelCardExportJobsResponse.ReadOnly =
    new Wrapper(impl)
}
