package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  MaxResults,
  RecommendationJobName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListInferenceRecommendationsJobStepsRequest(
    jobName: RecommendationJobName,
    status: Optional[zio.aws.sagemaker.model.RecommendationJobStatus] =
      Optional.Absent,
    stepType: Optional[zio.aws.sagemaker.model.RecommendationStepType] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobStepsRequest = {
    import ListInferenceRecommendationsJobStepsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobStepsRequest
      .builder()
      .jobName(RecommendationJobName.unwrap(jobName): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(stepType.map(value => value.unwrap))(_.stepType)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListInferenceRecommendationsJobStepsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListInferenceRecommendationsJobStepsRequest
      .wrap(buildAwsValue())
}
object ListInferenceRecommendationsJobStepsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobStepsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ListInferenceRecommendationsJobStepsRequest =
      zio.aws.sagemaker.model.ListInferenceRecommendationsJobStepsRequest(
        jobName,
        status.map(value => value),
        stepType.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def jobName: RecommendationJobName
    def status: Optional[zio.aws.sagemaker.model.RecommendationJobStatus]
    def stepType: Optional[zio.aws.sagemaker.model.RecommendationStepType]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getJobName: ZIO[Any, Nothing, RecommendationJobName] =
      ZIO.succeed(jobName)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.RecommendationJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStepType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.RecommendationStepType] =
      AwsError.unwrapOptionField("stepType", stepType)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobStepsRequest
  ) extends zio.aws.sagemaker.model.ListInferenceRecommendationsJobStepsRequest.ReadOnly {
    override val jobName: RecommendationJobName =
      zio.aws.sagemaker.model.primitives.RecommendationJobName(impl.jobName())
    override val status
        : Optional[zio.aws.sagemaker.model.RecommendationJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.sagemaker.model.RecommendationJobStatus.wrap(value)
        )
    override val stepType
        : Optional[zio.aws.sagemaker.model.RecommendationStepType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepType())
        .map(value =>
          zio.aws.sagemaker.model.RecommendationStepType.wrap(value)
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobStepsRequest
  ): zio.aws.sagemaker.model.ListInferenceRecommendationsJobStepsRequest.ReadOnly =
    new Wrapper(impl)
}
