package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.FailureReason
import scala.jdk.CollectionConverters.*
final case class LastUpdateStatus(
    status: zio.aws.sagemaker.model.LastUpdateStatusValue,
    failureReason: Optional[FailureReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.LastUpdateStatus = {
    import LastUpdateStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.LastUpdateStatus
      .builder()
      .status(status.unwrap)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.LastUpdateStatus.ReadOnly =
    zio.aws.sagemaker.model.LastUpdateStatus.wrap(buildAwsValue())
}
object LastUpdateStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.LastUpdateStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.LastUpdateStatus =
      zio.aws.sagemaker.model
        .LastUpdateStatus(status, failureReason.map(value => value))
    def status: zio.aws.sagemaker.model.LastUpdateStatusValue
    def failureReason: Optional[FailureReason]
    def getStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.LastUpdateStatusValue] =
      ZIO.succeed(status)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.LastUpdateStatus
  ) extends zio.aws.sagemaker.model.LastUpdateStatus.ReadOnly {
    override val status: zio.aws.sagemaker.model.LastUpdateStatusValue =
      zio.aws.sagemaker.model.LastUpdateStatusValue.wrap(impl.status())
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.LastUpdateStatus
  ): zio.aws.sagemaker.model.LastUpdateStatus.ReadOnly = new Wrapper(impl)
}
