package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait HyperParameterTuningJobObjectiveType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobObjectiveType
}
object HyperParameterTuningJobObjectiveType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobObjectiveType
  ): zio.aws.sagemaker.model.HyperParameterTuningJobObjectiveType =
    value match {
      case software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobObjectiveType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobObjectiveType.MAXIMIZE =>
        val r = Maximize
        r
      case software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobObjectiveType.MINIMIZE =>
        val r = Minimize
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.HyperParameterTuningJobObjectiveType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobObjectiveType =
      software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobObjectiveType.UNKNOWN_TO_SDK_VERSION
  }
  case object Maximize
      extends zio.aws.sagemaker.model.HyperParameterTuningJobObjectiveType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobObjectiveType =
      software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobObjectiveType.MAXIMIZE
  }
  case object Minimize
      extends zio.aws.sagemaker.model.HyperParameterTuningJobObjectiveType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobObjectiveType =
      software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobObjectiveType.MINIMIZE
  }
}
