package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.MetricValue
import scala.jdk.CollectionConverters.*
final case class FinalAutoMLJobObjectiveMetric(
    `type`: Optional[zio.aws.sagemaker.model.AutoMLJobObjectiveType] =
      Optional.Absent,
    metricName: zio.aws.sagemaker.model.AutoMLMetricEnum,
    value: MetricValue,
    standardMetricName: Optional[zio.aws.sagemaker.model.AutoMLMetricEnum] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.FinalAutoMLJobObjectiveMetric = {
    import FinalAutoMLJobObjectiveMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.FinalAutoMLJobObjectiveMetric
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .metricName(metricName.unwrap)
      .value(MetricValue.unwrap(value): java.lang.Float)
      .optionallyWith(standardMetricName.map(value => value.unwrap))(
        _.standardMetricName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.FinalAutoMLJobObjectiveMetric.ReadOnly =
    zio.aws.sagemaker.model.FinalAutoMLJobObjectiveMetric.wrap(buildAwsValue())
}
object FinalAutoMLJobObjectiveMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.FinalAutoMLJobObjectiveMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.FinalAutoMLJobObjectiveMetric =
      zio.aws.sagemaker.model.FinalAutoMLJobObjectiveMetric(
        `type`.map(value => value),
        metricName,
        value,
        standardMetricName.map(value => value)
      )
    def `type`: Optional[zio.aws.sagemaker.model.AutoMLJobObjectiveType]
    def metricName: zio.aws.sagemaker.model.AutoMLMetricEnum
    def value: MetricValue
    def standardMetricName: Optional[zio.aws.sagemaker.model.AutoMLMetricEnum]
    def getType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AutoMLJobObjectiveType] =
      AwsError.unwrapOptionField("type", `type`)
    def getMetricName
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.AutoMLMetricEnum] =
      ZIO.succeed(metricName)
    def getValue: ZIO[Any, Nothing, MetricValue] = ZIO.succeed(value)
    def getStandardMetricName
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AutoMLMetricEnum] =
      AwsError.unwrapOptionField("standardMetricName", standardMetricName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.FinalAutoMLJobObjectiveMetric
  ) extends zio.aws.sagemaker.model.FinalAutoMLJobObjectiveMetric.ReadOnly {
    override val `type`
        : Optional[zio.aws.sagemaker.model.AutoMLJobObjectiveType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.sagemaker.model.AutoMLJobObjectiveType.wrap(value)
        )
    override val metricName: zio.aws.sagemaker.model.AutoMLMetricEnum =
      zio.aws.sagemaker.model.AutoMLMetricEnum.wrap(impl.metricName())
    override val value: MetricValue =
      zio.aws.sagemaker.model.primitives.MetricValue(impl.value())
    override val standardMetricName
        : Optional[zio.aws.sagemaker.model.AutoMLMetricEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.standardMetricName())
        .map(value => zio.aws.sagemaker.model.AutoMLMetricEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.FinalAutoMLJobObjectiveMetric
  ): zio.aws.sagemaker.model.FinalAutoMLJobObjectiveMetric.ReadOnly =
    new Wrapper(impl)
}
