package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait FeatureStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.FeatureStatus
}
object FeatureStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.FeatureStatus
  ): zio.aws.sagemaker.model.FeatureStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.FeatureStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.FeatureStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.sagemaker.model.FeatureStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.FeatureStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FeatureStatus =
      software.amazon.awssdk.services.sagemaker.model.FeatureStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.sagemaker.model.FeatureStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FeatureStatus =
      software.amazon.awssdk.services.sagemaker.model.FeatureStatus.ENABLED
  }
  case object DISABLED extends zio.aws.sagemaker.model.FeatureStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FeatureStatus =
      software.amazon.awssdk.services.sagemaker.model.FeatureStatus.DISABLED
  }
}
