package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.FeatureName
import scala.jdk.CollectionConverters.*
final case class FeatureDefinition(
    featureName: Optional[FeatureName] = Optional.Absent,
    featureType: Optional[zio.aws.sagemaker.model.FeatureType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.FeatureDefinition = {
    import FeatureDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.FeatureDefinition
      .builder()
      .optionallyWith(
        featureName.map(value => FeatureName.unwrap(value): java.lang.String)
      )(_.featureName)
      .optionallyWith(featureType.map(value => value.unwrap))(_.featureType)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.FeatureDefinition.ReadOnly =
    zio.aws.sagemaker.model.FeatureDefinition.wrap(buildAwsValue())
}
object FeatureDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.FeatureDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.FeatureDefinition =
      zio.aws.sagemaker.model.FeatureDefinition(
        featureName.map(value => value),
        featureType.map(value => value)
      )
    def featureName: Optional[FeatureName]
    def featureType: Optional[zio.aws.sagemaker.model.FeatureType]
    def getFeatureName: ZIO[Any, AwsError, FeatureName] =
      AwsError.unwrapOptionField("featureName", featureName)
    def getFeatureType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.FeatureType] =
      AwsError.unwrapOptionField("featureType", featureType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.FeatureDefinition
  ) extends zio.aws.sagemaker.model.FeatureDefinition.ReadOnly {
    override val featureName: Optional[FeatureName] = zio.aws.core.internal
      .optionalFromNullable(impl.featureName())
      .map(value => zio.aws.sagemaker.model.primitives.FeatureName(value))
    override val featureType: Optional[zio.aws.sagemaker.model.FeatureType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureType())
        .map(value => zio.aws.sagemaker.model.FeatureType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.FeatureDefinition
  ): zio.aws.sagemaker.model.FeatureDefinition.ReadOnly = new Wrapper(impl)
}
