package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  DeploymentStageMaxResults,
  NextToken,
  EntityName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeEdgeDeploymentPlanRequest(
    edgeDeploymentPlanName: EntityName,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[DeploymentStageMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanRequest = {
    import DescribeEdgeDeploymentPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanRequest
      .builder()
      .edgeDeploymentPlanName(
        EntityName.unwrap(edgeDeploymentPlanName): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          DeploymentStageMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeEdgeDeploymentPlanRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeEdgeDeploymentPlanRequest
      .wrap(buildAwsValue())
}
object DescribeEdgeDeploymentPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeEdgeDeploymentPlanRequest =
      zio.aws.sagemaker.model.DescribeEdgeDeploymentPlanRequest(
        edgeDeploymentPlanName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def edgeDeploymentPlanName: EntityName
    def nextToken: Optional[NextToken]
    def maxResults: Optional[DeploymentStageMaxResults]
    def getEdgeDeploymentPlanName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(edgeDeploymentPlanName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, DeploymentStageMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanRequest
  ) extends zio.aws.sagemaker.model.DescribeEdgeDeploymentPlanRequest.ReadOnly {
    override val edgeDeploymentPlanName: EntityName =
      zio.aws.sagemaker.model.primitives
        .EntityName(impl.edgeDeploymentPlanName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[DeploymentStageMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.sagemaker.model.primitives.DeploymentStageMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanRequest
  ): zio.aws.sagemaker.model.DescribeEdgeDeploymentPlanRequest.ReadOnly =
    new Wrapper(impl)
}
