package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{SpaceName, DomainId}
import scala.jdk.CollectionConverters.*
final case class CreateSpaceRequest(
    domainId: DomainId,
    spaceName: SpaceName,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent,
    spaceSettings: Optional[zio.aws.sagemaker.model.SpaceSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateSpaceRequest = {
    import CreateSpaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateSpaceRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .spaceName(SpaceName.unwrap(spaceName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(spaceSettings.map(value => value.buildAwsValue()))(
        _.spaceSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateSpaceRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateSpaceRequest.wrap(buildAwsValue())
}
object CreateSpaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateSpaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateSpaceRequest =
      zio.aws.sagemaker.model.CreateSpaceRequest(
        domainId,
        spaceName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        spaceSettings.map(value => value.asEditable)
      )
    def domainId: DomainId
    def spaceName: SpaceName
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def spaceSettings: Optional[zio.aws.sagemaker.model.SpaceSettings.ReadOnly]
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getSpaceName: ZIO[Any, Nothing, SpaceName] = ZIO.succeed(spaceName)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSpaceSettings
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.SpaceSettings.ReadOnly] =
      AwsError.unwrapOptionField("spaceSettings", spaceSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateSpaceRequest
  ) extends zio.aws.sagemaker.model.CreateSpaceRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.sagemaker.model.primitives.DomainId(impl.domainId())
    override val spaceName: SpaceName =
      zio.aws.sagemaker.model.primitives.SpaceName(impl.spaceName())
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val spaceSettings
        : Optional[zio.aws.sagemaker.model.SpaceSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spaceSettings())
        .map(value => zio.aws.sagemaker.model.SpaceSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateSpaceRequest
  ): zio.aws.sagemaker.model.CreateSpaceRequest.ReadOnly = new Wrapper(impl)
}
