package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  SubnetId,
  RoleArn,
  SecurityGroupId,
  NotebookInstanceVolumeSizeInGB,
  NotebookInstanceName,
  KmsKeyId,
  CodeRepositoryNameOrUrl,
  NotebookInstanceLifecycleConfigName,
  PlatformIdentifier
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateNotebookInstanceRequest(
    notebookInstanceName: NotebookInstanceName,
    instanceType: zio.aws.sagemaker.model.InstanceType,
    subnetId: Optional[SubnetId] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    roleArn: RoleArn,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent,
    lifecycleConfigName: Optional[NotebookInstanceLifecycleConfigName] =
      Optional.Absent,
    directInternetAccess: Optional[
      zio.aws.sagemaker.model.DirectInternetAccess
    ] = Optional.Absent,
    volumeSizeInGB: Optional[NotebookInstanceVolumeSizeInGB] = Optional.Absent,
    acceleratorTypes: Optional[
      Iterable[zio.aws.sagemaker.model.NotebookInstanceAcceleratorType]
    ] = Optional.Absent,
    defaultCodeRepository: Optional[CodeRepositoryNameOrUrl] = Optional.Absent,
    additionalCodeRepositories: Optional[Iterable[CodeRepositoryNameOrUrl]] =
      Optional.Absent,
    rootAccess: Optional[zio.aws.sagemaker.model.RootAccess] = Optional.Absent,
    platformIdentifier: Optional[PlatformIdentifier] = Optional.Absent,
    instanceMetadataServiceConfiguration: Optional[
      zio.aws.sagemaker.model.InstanceMetadataServiceConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceRequest = {
    import CreateNotebookInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceRequest
      .builder()
      .notebookInstanceName(
        NotebookInstanceName.unwrap(notebookInstanceName): java.lang.String
      )
      .instanceType(instanceType.unwrap)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        lifecycleConfigName.map(value =>
          NotebookInstanceLifecycleConfigName.unwrap(value): java.lang.String
        )
      )(_.lifecycleConfigName)
      .optionallyWith(directInternetAccess.map(value => value.unwrap))(
        _.directInternetAccess
      )
      .optionallyWith(
        volumeSizeInGB.map(value =>
          NotebookInstanceVolumeSizeInGB.unwrap(value): Integer
        )
      )(_.volumeSizeInGB)
      .optionallyWith(
        acceleratorTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.acceleratorTypesWithStrings)
      .optionallyWith(
        defaultCodeRepository.map(value =>
          CodeRepositoryNameOrUrl.unwrap(value): java.lang.String
        )
      )(_.defaultCodeRepository)
      .optionallyWith(
        additionalCodeRepositories.map(value =>
          value.map { item =>
            CodeRepositoryNameOrUrl.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalCodeRepositories)
      .optionallyWith(rootAccess.map(value => value.unwrap))(_.rootAccess)
      .optionallyWith(
        platformIdentifier.map(value =>
          PlatformIdentifier.unwrap(value): java.lang.String
        )
      )(_.platformIdentifier)
      .optionallyWith(
        instanceMetadataServiceConfiguration.map(value => value.buildAwsValue())
      )(_.instanceMetadataServiceConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateNotebookInstanceRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateNotebookInstanceRequest.wrap(buildAwsValue())
}
object CreateNotebookInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateNotebookInstanceRequest =
      zio.aws.sagemaker.model.CreateNotebookInstanceRequest(
        notebookInstanceName,
        instanceType,
        subnetId.map(value => value),
        securityGroupIds.map(value => value),
        roleArn,
        kmsKeyId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lifecycleConfigName.map(value => value),
        directInternetAccess.map(value => value),
        volumeSizeInGB.map(value => value),
        acceleratorTypes.map(value => value),
        defaultCodeRepository.map(value => value),
        additionalCodeRepositories.map(value => value),
        rootAccess.map(value => value),
        platformIdentifier.map(value => value),
        instanceMetadataServiceConfiguration.map(value => value.asEditable)
      )
    def notebookInstanceName: NotebookInstanceName
    def instanceType: zio.aws.sagemaker.model.InstanceType
    def subnetId: Optional[SubnetId]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def roleArn: RoleArn
    def kmsKeyId: Optional[KmsKeyId]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def lifecycleConfigName: Optional[NotebookInstanceLifecycleConfigName]
    def directInternetAccess
        : Optional[zio.aws.sagemaker.model.DirectInternetAccess]
    def volumeSizeInGB: Optional[NotebookInstanceVolumeSizeInGB]
    def acceleratorTypes: Optional[
      List[zio.aws.sagemaker.model.NotebookInstanceAcceleratorType]
    ]
    def defaultCodeRepository: Optional[CodeRepositoryNameOrUrl]
    def additionalCodeRepositories: Optional[List[CodeRepositoryNameOrUrl]]
    def rootAccess: Optional[zio.aws.sagemaker.model.RootAccess]
    def platformIdentifier: Optional[PlatformIdentifier]
    def instanceMetadataServiceConfiguration: Optional[
      zio.aws.sagemaker.model.InstanceMetadataServiceConfiguration.ReadOnly
    ]
    def getNotebookInstanceName: ZIO[Any, Nothing, NotebookInstanceName] =
      ZIO.succeed(notebookInstanceName)
    def getInstanceType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.InstanceType] =
      ZIO.succeed(instanceType)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getLifecycleConfigName
        : ZIO[Any, AwsError, NotebookInstanceLifecycleConfigName] =
      AwsError.unwrapOptionField("lifecycleConfigName", lifecycleConfigName)
    def getDirectInternetAccess
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.DirectInternetAccess] =
      AwsError.unwrapOptionField("directInternetAccess", directInternetAccess)
    def getVolumeSizeInGB: ZIO[Any, AwsError, NotebookInstanceVolumeSizeInGB] =
      AwsError.unwrapOptionField("volumeSizeInGB", volumeSizeInGB)
    def getAcceleratorTypes: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.NotebookInstanceAcceleratorType
    ]] = AwsError.unwrapOptionField("acceleratorTypes", acceleratorTypes)
    def getDefaultCodeRepository: ZIO[Any, AwsError, CodeRepositoryNameOrUrl] =
      AwsError.unwrapOptionField("defaultCodeRepository", defaultCodeRepository)
    def getAdditionalCodeRepositories
        : ZIO[Any, AwsError, List[CodeRepositoryNameOrUrl]] =
      AwsError.unwrapOptionField(
        "additionalCodeRepositories",
        additionalCodeRepositories
      )
    def getRootAccess: ZIO[Any, AwsError, zio.aws.sagemaker.model.RootAccess] =
      AwsError.unwrapOptionField("rootAccess", rootAccess)
    def getPlatformIdentifier: ZIO[Any, AwsError, PlatformIdentifier] =
      AwsError.unwrapOptionField("platformIdentifier", platformIdentifier)
    def getInstanceMetadataServiceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.InstanceMetadataServiceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "instanceMetadataServiceConfiguration",
      instanceMetadataServiceConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceRequest
  ) extends zio.aws.sagemaker.model.CreateNotebookInstanceRequest.ReadOnly {
    override val notebookInstanceName: NotebookInstanceName =
      zio.aws.sagemaker.model.primitives
        .NotebookInstanceName(impl.notebookInstanceName())
    override val instanceType: zio.aws.sagemaker.model.InstanceType =
      zio.aws.sagemaker.model.InstanceType.wrap(impl.instanceType())
    override val subnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.sagemaker.model.primitives.SubnetId(value))
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val lifecycleConfigName
        : Optional[NotebookInstanceLifecycleConfigName] = zio.aws.core.internal
      .optionalFromNullable(impl.lifecycleConfigName())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .NotebookInstanceLifecycleConfigName(value)
      )
    override val directInternetAccess
        : Optional[zio.aws.sagemaker.model.DirectInternetAccess] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directInternetAccess())
        .map(value => zio.aws.sagemaker.model.DirectInternetAccess.wrap(value))
    override val volumeSizeInGB: Optional[NotebookInstanceVolumeSizeInGB] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeSizeInGB())
        .map(value =>
          zio.aws.sagemaker.model.primitives
            .NotebookInstanceVolumeSizeInGB(value)
        )
    override val acceleratorTypes: Optional[
      List[zio.aws.sagemaker.model.NotebookInstanceAcceleratorType]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.acceleratorTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.NotebookInstanceAcceleratorType.wrap(item)
        }.toList
      )
    override val defaultCodeRepository: Optional[CodeRepositoryNameOrUrl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultCodeRepository())
        .map(value =>
          zio.aws.sagemaker.model.primitives.CodeRepositoryNameOrUrl(value)
        )
    override val additionalCodeRepositories
        : Optional[List[CodeRepositoryNameOrUrl]] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalCodeRepositories())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.CodeRepositoryNameOrUrl(item)
        }.toList
      )
    override val rootAccess: Optional[zio.aws.sagemaker.model.RootAccess] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rootAccess())
        .map(value => zio.aws.sagemaker.model.RootAccess.wrap(value))
    override val platformIdentifier: Optional[PlatformIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformIdentifier())
        .map(value =>
          zio.aws.sagemaker.model.primitives.PlatformIdentifier(value)
        )
    override val instanceMetadataServiceConfiguration: Optional[
      zio.aws.sagemaker.model.InstanceMetadataServiceConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceMetadataServiceConfiguration())
      .map(value =>
        zio.aws.sagemaker.model.InstanceMetadataServiceConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceRequest
  ): zio.aws.sagemaker.model.CreateNotebookInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
